% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtpwr.2rate.R
\name{crtpwr.2rate}
\alias{crtpwr.2rate}
\title{Power calculations for simple cluster randomized trials, count outcome}
\usage{
crtpwr.2rate(alpha = 0.05, power = 0.8, m = NA, py = NA, r1 = NA,
  r2 = NA, cvb = NA, tol = .Machine$double.eps^0.25)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{m}{The number of clusters per condition. It must be greater than 1.}

\item{py}{The number of person-years of observation per cluster.}

\item{r1}{The expected mean event rate per unit time in the treatment group.}

\item{r2}{The mean event rate per unit time in the control group.}

\item{cvb}{The between-cluster coefficient of variation.}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed argument.
#' #' @examples 
# Find the number of clusters per condition needed for a trial with alpha = .05, 
# power = 0.8, 10 person-years per cluster, rate
in condition 1 of .1 and condition 2 of .2, and cvb = 0.1.
crtpwr.2rate(py=10, r1=.1, r2=.2, cvb=.1)
# 
# The result, showimg m of greater than 24, suggests 25 clusters per condition should be used.
}
\description{
Compute the power of a simple cluster randomized trial with a count outcome,
or determine parameters to obtain a target power.
}
\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com})
}

