% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converter.R
\name{rewireCpp}
\alias{rewireCpp}
\title{Randomizes a weighted graph while keeping the degree distribution constant.}
\usage{
rewireCpp(
  g,
  Q = 100,
  weight_sel = "max_weight",
  lower_bound = 0,
  upper_bound = NULL
)
}
\arguments{
\item{g}{\code{igraph} graph, which can be weighted.}

\item{Q}{Numeric. Parameter that controls the number of iterations, which will be Q times the order of the graph.}

\item{weight_sel}{can be either "const_var" or "max_weight".}

\item{lower_bound, upper_bound}{Bounds to the edge weights. The randomization
process will avoid steps that would make edge weights fall outside these
bounds. Set to NULL for no bound. By default, 0 and NULL respectively.}
}
\value{
The rewired graph.
}
\description{
Converts the graph to a weighted edge list in NumericMatrix, which is compatible with Rcpp.
The Rcpp function "randomize" is called, and then the resulting edge list is converted
back into an igraph object.
}
