% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme.R
\name{vcovCR.lme}
\alias{vcovCR.lme}
\title{Cluster-robust variance-covariance matrix for an lme object.}
\usage{
\method{vcovCR}{lme}(obj, cluster, type, target, inverse_var,
  form = "sandwich", ...)
}
\arguments{
\item{obj}{Fitted model for which to calculate the variance-covariance matrix}

\item{cluster}{Optional expression or vector indicating which observations 
belong to the same cluster. If not specified, will be set to 
\code{getGroups(obj)}.}

\item{type}{Character string specifying which small-sample adjustment should 
be used, with available options \code{"CR0"}, \code{"CR1"}, \code{"CR1p"},
\code{"CR1S"}, \code{"CR2"}, or \code{"CR3"}. See "Details" section of 
\code{\link{vcovCR}} for further information.}

\item{target}{Optional matrix or vector describing the working 
variance-covariance model used to calculate the \code{CR2} and \code{CR4} 
adjustment matrices. If not specified, the target is taken to be the
estimated variance-covariance structure of the \code{lme} object.}

\item{inverse_var}{Optional logical indicating whether the weights used in 
fitting the model are inverse-variance. If not specified, \code{vcovCR} 
will attempt to infer a value.}

\item{form}{Controls the form of the returned matrix. The default 
\code{"sandwich"} will return the sandwich variance-covariance matrix. 
Alternately, setting \code{form = "meat"} will return only the meat of the 
sandwich and setting \code{form = B}, where \code{B} is a matrix of 
appropriate dimension, will return the sandwich variance-covariance matrix 
calculated using \code{B} as the bread.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists 
  of a matrix of the estimated variance of and covariances between the 
  regression coefficient estimates.
}
\description{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates from a \code{\link[nlme]{lme}} object.
}
\examples{
library(nlme)
rat_weight <- lme(weight ~ Time * Diet, data=BodyWeight, ~ Time | Rat) 
vcovCR(rat_weight, type = "CR2")

data(egsingle, package = "mlmRev")
math_model <- lme(math ~ year * size + female + black + hispanic, 
                  random = list(~ year | schoolid, ~ 1 | childid), 
                  data = egsingle)
vcovCR(math_model, type = "CR2")

}
\seealso{
\code{\link{vcovCR}}
}

