% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gls.R
\name{vcovCR.gls}
\alias{vcovCR.gls}
\title{Cluster-robust variance-covariance matrix for a gls object.}
\usage{
\method{vcovCR}{gls}(obj, cluster, type, target, inverse_var,
  form = "sandwich", ...)
}
\arguments{
\item{obj}{Fitted model for which to calcualte the variance-covariance matrix}

\item{cluster}{Optional expression or vector indicating which observations 
belong to the same cluster. If not specified, will be set to 
\code{getGroups(obj)}.}

\item{type}{Character string specifying which small-sample adjustment should 
be used.}

\item{target}{Optional matrix or vector describing the working 
variance-covariance model used to calculate the \code{CR2} and \code{CR4} 
adjustment matrices. If not specified, the target is taken to be the
estimated variance-covariance structure of the \code{gls} object.}

\item{inverse_var}{Optional logical indicating whether the weights used in 
fitting the model are inverse-variance. If not specified, \code{vcovCR} 
will attempt to infer a value.}

\item{form}{Controls the form of the returned matrix. The default 
\code{"sandwich"} will return the sandwich variance-covariance matrix. 
Alternately, setting \code{form = "meat"} will return only the meat of the 
sandwich and setting \code{form = B}, where \code{B} is a matrix of 
appropriate dimension, will return the sandwich variance-covariance matrix 
calculated using \code{B} as the bread.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists 
  of a matrix of the estimated variance of and covariances between the 
  regression coefficient estimates.
}
\description{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates from a \code{\link[nlme]{gls}} object.
}
\seealso{
\code{\link{vcovCR}}
}

