/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMessageBatchRequestMarshaller
implements Marshaller<Request<SendMessageBatchRequest>, SendMessageBatchRequest> {
    @Override
    public Request<SendMessageBatchRequest> marshall(SendMessageBatchRequest sendMessageBatchRequest) {
        if (sendMessageBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendMessageBatchRequest> request = new DefaultRequest<SendMessageBatchRequest>(sendMessageBatchRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessageBatch");
        request.addParameter("Version", "2011-10-01");
        if (sendMessageBatchRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(sendMessageBatchRequest.getQueueUrl()));
        }
        List<SendMessageBatchRequestEntry> entriesList = sendMessageBatchRequest.getEntries();
        int entriesListIndex = 1;
        for (SendMessageBatchRequestEntry entriesListValue : entriesList) {
            SendMessageBatchRequestEntry sendMessageBatchRequestEntryMember = entriesListValue;
            if (sendMessageBatchRequestEntryMember != null) {
                if (sendMessageBatchRequestEntryMember.getId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString(sendMessageBatchRequestEntryMember.getId()));
                }
                if (sendMessageBatchRequestEntryMember.getMessageBody() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageBody", StringUtils.fromString(sendMessageBatchRequestEntryMember.getMessageBody()));
                }
                if (sendMessageBatchRequestEntryMember.getDelaySeconds() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".DelaySeconds", StringUtils.fromInteger(sendMessageBatchRequestEntryMember.getDelaySeconds()));
                }
            }
            ++entriesListIndex;
        }
        return request;
    }
}

