/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.test;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.ActivityExecutionContext;
import com.amazonaws.services.simpleworkflow.flow.ActivityFailureException;
import com.amazonaws.services.simpleworkflow.flow.ActivityTaskFailedException;
import com.amazonaws.services.simpleworkflow.flow.ActivityTaskTimedOutException;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.ScheduleActivityTaskFailedException;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.ExecuteActivityParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericActivityClient;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskTimeoutType;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.model.ScheduleActivityTaskFailedCause;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGenericActivityClient
implements GenericActivityClient {
    protected final Map<String, ActivityImplementationFactory> factories = new HashMap<String, ActivityImplementationFactory>();
    protected final Map<ActivityType, ActivityTypeRegistrationOptions> registrationOptions = new HashMap<ActivityType, ActivityTypeRegistrationOptions>();
    protected final Map<ActivityType, String> workerTaskLists = new HashMap<ActivityType, String>();
    protected final DecisionContextProvider decisionContextProvider;

    public TestGenericActivityClient(DecisionContextProvider decisionContextProvider) {
        this.decisionContextProvider = decisionContextProvider;
    }

    public TestGenericActivityClient() {
        this(new DecisionContextProviderImpl());
    }

    public void addFactory(String taskListToListen, ActivityImplementationFactory factory) {
        this.factories.put(taskListToListen, factory);
        Iterable<ActivityType> typesToRegister = factory.getActivityTypesToRegister();
        for (ActivityType activityType : typesToRegister) {
            ActivityImplementation implementation = factory.getActivityImplementation(activityType);
            ActivityTypeRegistrationOptions ro = implementation.getRegistrationOptions();
            this.registrationOptions.put(activityType, ro);
            this.workerTaskLists.put(activityType, taskListToListen);
        }
    }

    @Override
    public Promise<String> scheduleActivityTask(ExecuteActivityParameters parameters) {
        ActivityImplementationFactory factory;
        ActivityType activityType = parameters.getActivityType();
        Settable<String> result = new Settable<String>();
        ActivityTask activityTask = new ActivityTask();
        String activityId = parameters.getActivityId();
        if (activityId == null) {
            activityId = this.decisionContextProvider.getDecisionContext().getWorkflowClient().generateUniqueId();
        }
        activityTask.setActivityId(activityId);
        activityTask.setActivityType(activityType);
        activityTask.setInput(parameters.getInput());
        activityTask.setStartedEventId(0L);
        activityTask.setTaskToken("dummyTaskToken");
        DecisionContext decisionContext = this.decisionContextProvider.getDecisionContext();
        WorkflowExecution workflowExecution = decisionContext.getWorkflowContext().getWorkflowExecution();
        activityTask.setWorkflowExecution(workflowExecution);
        String taskList = parameters.getTaskList();
        if (taskList == null) {
            ActivityTypeRegistrationOptions ro = this.registrationOptions.get(activityType);
            if (ro == null) {
                String cause = ScheduleActivityTaskFailedCause.ACTIVITY_TYPE_DOES_NOT_EXIST.toString();
                throw new ScheduleActivityTaskFailedException(0L, activityType, activityId, cause);
            }
            taskList = ro.getDefaultTaskList();
            if ("NO_DEFAULT_TASK_LIST".equals(taskList)) {
                String cause = ScheduleActivityTaskFailedCause.DEFAULT_TASK_LIST_UNDEFINED.toString();
                throw new ScheduleActivityTaskFailedException(0L, activityType, activityId, cause);
            }
            if (taskList == null) {
                taskList = this.workerTaskLists.get(activityType);
            }
        }
        if ((factory = this.factories.get(taskList)) == null) {
            String timeoutType = ActivityTaskTimeoutType.SCHEDULE_TO_START.toString();
            throw new ActivityTaskTimedOutException(0L, activityType, activityId, timeoutType, null);
        }
        ActivityImplementation impl = factory.getActivityImplementation(activityType);
        if (impl == null) {
            String cause = ScheduleActivityTaskFailedCause.ACTIVITY_TYPE_DOES_NOT_EXIST.toString();
            throw new ScheduleActivityTaskFailedException(0L, activityType, activityId, cause);
        }
        TestActivityExecutionContext executionContext = new TestActivityExecutionContext(activityTask, workflowExecution);
        try {
            String activityResult = impl.execute(executionContext);
            result.set(activityResult);
        }
        catch (Throwable e) {
            if (e instanceof ActivityFailureException) {
                ActivityFailureException falure = (ActivityFailureException)e;
                throw new ActivityTaskFailedException(0L, activityType, parameters.getActivityId(), falure.getReason(), falure.getDetails());
            }
            ActivityTaskFailedException failure = new ActivityTaskFailedException(0L, activityType, parameters.getActivityId(), e.getMessage(), null);
            failure.initCause(e);
            throw failure;
        }
        return result;
    }

    @Override
    public Promise<String> scheduleActivityTask(String activity, String version, String input) {
        ExecuteActivityParameters parameters = new ExecuteActivityParameters();
        ActivityType activityType = new ActivityType();
        activityType.setName(activity);
        activityType.setVersion(version);
        parameters.setActivityType(activityType);
        parameters.setInput(input);
        return this.scheduleActivityTask(parameters);
    }

    @Override
    public Promise<String> scheduleActivityTask(final String activity, final String version, final Promise<String> input) {
        final Settable<String> result = new Settable<String>();
        new Task(new Promise[]{input}){

            protected void doExecute() throws Throwable {
                result.chain(TestGenericActivityClient.this.scheduleActivityTask(activity, version, (String)input.get()));
            }
        };
        return result;
    }

    private final class TestActivityExecutionContext
    extends ActivityExecutionContext {
        private final ActivityTask activityTask;
        private final WorkflowExecution workflowExecution;

        private TestActivityExecutionContext(ActivityTask activityTask, WorkflowExecution workflowExecution) {
            this.activityTask = activityTask;
            this.workflowExecution = workflowExecution;
        }

        public void recordActivityHeartbeat(String details) throws AmazonServiceException, AmazonClientException {
        }

        public ActivityTask getTask() {
            return this.activityTask;
        }

        public AmazonSimpleWorkflow getService() {
            throw new UnsupportedOperationException("not implemented");
        }

        public String getTaskToken() {
            return this.activityTask.getTaskToken();
        }

        public WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }
    }
}

