/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.importexport.AmazonImportExportAsync;
import com.amazonaws.services.importexport.AmazonImportExportClient;
import com.amazonaws.services.importexport.model.CancelJobRequest;
import com.amazonaws.services.importexport.model.CancelJobResult;
import com.amazonaws.services.importexport.model.CreateJobRequest;
import com.amazonaws.services.importexport.model.CreateJobResult;
import com.amazonaws.services.importexport.model.GetStatusRequest;
import com.amazonaws.services.importexport.model.GetStatusResult;
import com.amazonaws.services.importexport.model.ListJobsRequest;
import com.amazonaws.services.importexport.model.ListJobsResult;
import com.amazonaws.services.importexport.model.UpdateJobRequest;
import com.amazonaws.services.importexport.model.UpdateJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonImportExportAsyncClient
extends AmazonImportExportClient
implements AmazonImportExportAsync {
    private ExecutorService executorService;

    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CreateJobResult> createJobAsync(final CreateJobRequest createJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                return AmazonImportExportAsyncClient.this.createJob(createJobRequest);
            }
        });
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(final CancelJobRequest cancelJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                return AmazonImportExportAsyncClient.this.cancelJob(cancelJobRequest);
            }
        });
    }

    @Override
    public Future<GetStatusResult> getStatusAsync(final GetStatusRequest getStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetStatusResult>(){

            @Override
            public GetStatusResult call() throws Exception {
                return AmazonImportExportAsyncClient.this.getStatus(getStatusRequest);
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest listJobsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                return AmazonImportExportAsyncClient.this.listJobs(listJobsRequest);
            }
        });
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(final UpdateJobRequest updateJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateJobResult>(){

            @Override
            public UpdateJobResult call() throws Exception {
                return AmazonImportExportAsyncClient.this.updateJob(updateJobRequest);
            }
        });
    }
}

