/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.services.elasticache.model.CacheNode;
import com.amazonaws.services.elasticache.model.CacheParameterGroupStatus;
import com.amazonaws.services.elasticache.model.CacheSecurityGroupMembership;
import com.amazonaws.services.elasticache.model.NotificationConfiguration;
import com.amazonaws.services.elasticache.model.PendingModifiedValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheCluster {
    private String cacheClusterId;
    private String cacheNodeType;
    private String engine;
    private String engineVersion;
    private String cacheClusterStatus;
    private Integer numCacheNodes;
    private String preferredAvailabilityZone;
    private Date cacheClusterCreateTime;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private NotificationConfiguration notificationConfiguration;
    private List<CacheSecurityGroupMembership> cacheSecurityGroups;
    private CacheParameterGroupStatus cacheParameterGroup;
    private List<CacheNode> cacheNodes;
    private Boolean autoMinorVersionUpgrade;

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public CacheCluster withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public CacheCluster withCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public CacheCluster withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public CacheCluster withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getCacheClusterStatus() {
        return this.cacheClusterStatus;
    }

    public void setCacheClusterStatus(String cacheClusterStatus) {
        this.cacheClusterStatus = cacheClusterStatus;
    }

    public CacheCluster withCacheClusterStatus(String cacheClusterStatus) {
        this.cacheClusterStatus = cacheClusterStatus;
        return this;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public CacheCluster withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public String getPreferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
    }

    public CacheCluster withPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
        return this;
    }

    public Date getCacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public void setCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
    }

    public CacheCluster withCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public CacheCluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public CacheCluster withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
        return this;
    }

    public NotificationConfiguration getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    public void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public CacheCluster withNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
        return this;
    }

    public List<CacheSecurityGroupMembership> getCacheSecurityGroups() {
        if (this.cacheSecurityGroups == null) {
            this.cacheSecurityGroups = new ArrayList<CacheSecurityGroupMembership>();
        }
        return this.cacheSecurityGroups;
    }

    public void setCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
        if (cacheSecurityGroups == null) {
            this.cacheSecurityGroups = null;
            return;
        }
        ArrayList<CacheSecurityGroupMembership> cacheSecurityGroupsCopy = new ArrayList<CacheSecurityGroupMembership>(cacheSecurityGroups.size());
        cacheSecurityGroupsCopy.addAll(cacheSecurityGroups);
        this.cacheSecurityGroups = cacheSecurityGroupsCopy;
    }

    public CacheCluster withCacheSecurityGroups(CacheSecurityGroupMembership ... cacheSecurityGroups) {
        if (this.getCacheSecurityGroups() == null) {
            this.setCacheSecurityGroups(new ArrayList<CacheSecurityGroupMembership>(cacheSecurityGroups.length));
        }
        for (CacheSecurityGroupMembership value : cacheSecurityGroups) {
            this.getCacheSecurityGroups().add(value);
        }
        return this;
    }

    public CacheCluster withCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
        if (cacheSecurityGroups == null) {
            this.cacheSecurityGroups = null;
        } else {
            ArrayList<CacheSecurityGroupMembership> cacheSecurityGroupsCopy = new ArrayList<CacheSecurityGroupMembership>(cacheSecurityGroups.size());
            cacheSecurityGroupsCopy.addAll(cacheSecurityGroups);
            this.cacheSecurityGroups = cacheSecurityGroupsCopy;
        }
        return this;
    }

    public CacheParameterGroupStatus getCacheParameterGroup() {
        return this.cacheParameterGroup;
    }

    public void setCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
        this.cacheParameterGroup = cacheParameterGroup;
    }

    public CacheCluster withCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
        this.cacheParameterGroup = cacheParameterGroup;
        return this;
    }

    public List<CacheNode> getCacheNodes() {
        if (this.cacheNodes == null) {
            this.cacheNodes = new ArrayList<CacheNode>();
        }
        return this.cacheNodes;
    }

    public void setCacheNodes(Collection<CacheNode> cacheNodes) {
        if (cacheNodes == null) {
            this.cacheNodes = null;
            return;
        }
        ArrayList<CacheNode> cacheNodesCopy = new ArrayList<CacheNode>(cacheNodes.size());
        cacheNodesCopy.addAll(cacheNodes);
        this.cacheNodes = cacheNodesCopy;
    }

    public CacheCluster withCacheNodes(CacheNode ... cacheNodes) {
        if (this.getCacheNodes() == null) {
            this.setCacheNodes(new ArrayList<CacheNode>(cacheNodes.length));
        }
        for (CacheNode value : cacheNodes) {
            this.getCacheNodes().add(value);
        }
        return this;
    }

    public CacheCluster withCacheNodes(Collection<CacheNode> cacheNodes) {
        if (cacheNodes == null) {
            this.cacheNodes = null;
        } else {
            ArrayList<CacheNode> cacheNodesCopy = new ArrayList<CacheNode>(cacheNodes.size());
            cacheNodesCopy.addAll(cacheNodes);
            this.cacheNodes = cacheNodesCopy;
        }
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public CacheCluster withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cacheClusterId != null) {
            sb.append("CacheClusterId: " + this.cacheClusterId + ", ");
        }
        if (this.cacheNodeType != null) {
            sb.append("CacheNodeType: " + this.cacheNodeType + ", ");
        }
        if (this.engine != null) {
            sb.append("Engine: " + this.engine + ", ");
        }
        if (this.engineVersion != null) {
            sb.append("EngineVersion: " + this.engineVersion + ", ");
        }
        if (this.cacheClusterStatus != null) {
            sb.append("CacheClusterStatus: " + this.cacheClusterStatus + ", ");
        }
        if (this.numCacheNodes != null) {
            sb.append("NumCacheNodes: " + this.numCacheNodes + ", ");
        }
        if (this.preferredAvailabilityZone != null) {
            sb.append("PreferredAvailabilityZone: " + this.preferredAvailabilityZone + ", ");
        }
        if (this.cacheClusterCreateTime != null) {
            sb.append("CacheClusterCreateTime: " + this.cacheClusterCreateTime + ", ");
        }
        if (this.preferredMaintenanceWindow != null) {
            sb.append("PreferredMaintenanceWindow: " + this.preferredMaintenanceWindow + ", ");
        }
        if (this.pendingModifiedValues != null) {
            sb.append("PendingModifiedValues: " + this.pendingModifiedValues + ", ");
        }
        if (this.notificationConfiguration != null) {
            sb.append("NotificationConfiguration: " + this.notificationConfiguration + ", ");
        }
        if (this.cacheSecurityGroups != null) {
            sb.append("CacheSecurityGroups: " + this.cacheSecurityGroups + ", ");
        }
        if (this.cacheParameterGroup != null) {
            sb.append("CacheParameterGroup: " + this.cacheParameterGroup + ", ");
        }
        if (this.cacheNodes != null) {
            sb.append("CacheNodes: " + this.cacheNodes + ", ");
        }
        if (this.autoMinorVersionUpgrade != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.autoMinorVersionUpgrade + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterStatus() == null ? 0 : this.getCacheClusterStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredAvailabilityZone() == null ? 0 : this.getPreferredAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterCreateTime() == null ? 0 : this.getCacheClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationConfiguration() == null ? 0 : this.getNotificationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSecurityGroups() == null ? 0 : ((Object)this.getCacheSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroup() == null ? 0 : this.getCacheParameterGroup().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodes() == null ? 0 : ((Object)this.getCacheNodes()).hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheCluster)) {
            return false;
        }
        CacheCluster other = (CacheCluster)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        if (other.getCacheNodeType() != null && !other.getCacheNodeType().equals(this.getCacheNodeType())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getCacheClusterStatus() == null ^ this.getCacheClusterStatus() == null) {
            return false;
        }
        if (other.getCacheClusterStatus() != null && !other.getCacheClusterStatus().equals(this.getCacheClusterStatus())) {
            return false;
        }
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() == null ^ this.getPreferredAvailabilityZone() == null) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() != null && !other.getPreferredAvailabilityZone().equals(this.getPreferredAvailabilityZone())) {
            return false;
        }
        if (other.getCacheClusterCreateTime() == null ^ this.getCacheClusterCreateTime() == null) {
            return false;
        }
        if (other.getCacheClusterCreateTime() != null && !other.getCacheClusterCreateTime().equals(this.getCacheClusterCreateTime())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getNotificationConfiguration() == null ^ this.getNotificationConfiguration() == null) {
            return false;
        }
        if (other.getNotificationConfiguration() != null && !other.getNotificationConfiguration().equals(this.getNotificationConfiguration())) {
            return false;
        }
        if (other.getCacheSecurityGroups() == null ^ this.getCacheSecurityGroups() == null) {
            return false;
        }
        if (other.getCacheSecurityGroups() != null && !((Object)other.getCacheSecurityGroups()).equals(this.getCacheSecurityGroups())) {
            return false;
        }
        if (other.getCacheParameterGroup() == null ^ this.getCacheParameterGroup() == null) {
            return false;
        }
        if (other.getCacheParameterGroup() != null && !other.getCacheParameterGroup().equals(this.getCacheParameterGroup())) {
            return false;
        }
        if (other.getCacheNodes() == null ^ this.getCacheNodes() == null) {
            return false;
        }
        if (other.getCacheNodes() != null && !((Object)other.getCacheNodes()).equals(this.getCacheNodes())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        return other.isAutoMinorVersionUpgrade() == null || other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade());
    }
}

