/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollForActivityTaskRequestMarshaller
implements Marshaller<Request<PollForActivityTaskRequest>, PollForActivityTaskRequest> {
    @Override
    public Request<PollForActivityTaskRequest> marshall(PollForActivityTaskRequest pollForActivityTaskRequest) {
        if (pollForActivityTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PollForActivityTaskRequest> request = new DefaultRequest<PollForActivityTaskRequest>(pollForActivityTaskRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.PollForActivityTask";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            TaskList taskListTaskList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (pollForActivityTaskRequest.getDomain() != null) {
                jsonWriter.key("domain").value(pollForActivityTaskRequest.getDomain());
            }
            if (pollForActivityTaskRequest != null && (taskListTaskList = pollForActivityTaskRequest.getTaskList()) != null) {
                jsonWriter.key("taskList").object();
                if (taskListTaskList.getName() != null) {
                    jsonWriter.key("name").value(taskListTaskList.getName());
                }
                jsonWriter.endObject();
            }
            if (pollForActivityTaskRequest.getIdentity() != null) {
                jsonWriter.key("identity").value(pollForActivityTaskRequest.getIdentity());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

