/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    @Override
    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ScanRequest> request = new DefaultRequest<ScanRequest>(scanRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.Scan";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            Key keyExclusiveStartKey;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (scanRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(scanRequest.getTableName());
            }
            if (scanRequest != null) {
                List<String> attributesToGetList = scanRequest.getAttributesToGet();
                int attributesToGetListIndex = 0;
                if (attributesToGetList != null && attributesToGetList.size() > 0) {
                    jsonWriter.key("AttributesToGet").array();
                    for (String attributesToGetListValue : attributesToGetList) {
                        if (attributesToGetListValue != null) {
                            jsonWriter.value(attributesToGetListValue);
                        } else {
                            jsonWriter.value(null);
                        }
                        ++attributesToGetListIndex;
                    }
                    jsonWriter.endArray();
                }
            }
            if (scanRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(scanRequest.getLimit());
            }
            if (scanRequest.isCount() != null) {
                jsonWriter.key("Count").value(scanRequest.isCount());
            }
            if (scanRequest.getScanFilter() != null) {
                int scanFilterEntryIndex = 1;
                jsonWriter.key("ScanFilter").object();
                for (Map.Entry<String, Condition> scanFilterListValue : scanRequest.getScanFilter().entrySet()) {
                    List<AttributeValue> attributeValueListList;
                    jsonWriter.key(scanFilterListValue.getKey());
                    jsonWriter.object();
                    if (scanFilterListValue.getValue() != null && (attributeValueListList = scanFilterListValue.getValue().getAttributeValueList()) != null && attributeValueListList.size() > 0) {
                        int attributeValueListListIndex = 1;
                        jsonWriter.key("AttributeValueList").array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            jsonWriter.object();
                            if (attributeValueListListValue.getS() != null) {
                                jsonWriter.key("S").value(attributeValueListListValue.getS());
                            }
                            if (attributeValueListListValue.getN() != null) {
                                jsonWriter.key("N").value(attributeValueListListValue.getN());
                            }
                            if (attributeValueListListValue != null) {
                                List<String> sSList = attributeValueListListValue.getSS();
                                int sSListIndex = 0;
                                if (sSList != null && sSList.size() > 0) {
                                    jsonWriter.key("SS").array();
                                    for (String sSListValue : sSList) {
                                        if (sSListValue != null) {
                                            jsonWriter.value(sSListValue);
                                        } else {
                                            jsonWriter.value(null);
                                        }
                                        ++sSListIndex;
                                    }
                                    jsonWriter.endArray();
                                }
                            }
                            if (attributeValueListListValue != null) {
                                List<String> nSList = attributeValueListListValue.getNS();
                                int nSListIndex = 0;
                                if (nSList != null && nSList.size() > 0) {
                                    jsonWriter.key("NS").array();
                                    for (String nSListValue : nSList) {
                                        if (nSListValue != null) {
                                            jsonWriter.value(nSListValue);
                                        } else {
                                            jsonWriter.value(null);
                                        }
                                        ++nSListIndex;
                                    }
                                    jsonWriter.endArray();
                                }
                            }
                            jsonWriter.endObject();
                            ++attributeValueListListIndex;
                        }
                        jsonWriter.endArray();
                    }
                    if (scanFilterListValue.getValue().getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value(scanFilterListValue.getValue().getComparisonOperator());
                    }
                    jsonWriter.endObject();
                    ++scanFilterEntryIndex;
                }
                jsonWriter.endObject();
            }
            if (scanRequest != null && (keyExclusiveStartKey = scanRequest.getExclusiveStartKey()) != null) {
                AttributeValue attributeValueRangeKeyElement;
                List<String> nSList;
                List<String> sSList;
                AttributeValue attributeValueHashKeyElement;
                jsonWriter.key("ExclusiveStartKey").object();
                if (keyExclusiveStartKey != null && (attributeValueHashKeyElement = keyExclusiveStartKey.getHashKeyElement()) != null) {
                    jsonWriter.key("HashKeyElement").object();
                    if (attributeValueHashKeyElement.getS() != null) {
                        jsonWriter.key("S").value(attributeValueHashKeyElement.getS());
                    }
                    if (attributeValueHashKeyElement.getN() != null) {
                        jsonWriter.key("N").value(attributeValueHashKeyElement.getN());
                    }
                    if (attributeValueHashKeyElement != null) {
                        sSList = attributeValueHashKeyElement.getSS();
                        int sSListIndex = 0;
                        if (sSList != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                if (sSListValue != null) {
                                    jsonWriter.value(sSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++sSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    if (attributeValueHashKeyElement != null) {
                        nSList = attributeValueHashKeyElement.getNS();
                        int nSListIndex = 0;
                        if (nSList != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                if (nSListValue != null) {
                                    jsonWriter.value(nSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++nSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    jsonWriter.endObject();
                }
                if (keyExclusiveStartKey != null && (attributeValueRangeKeyElement = keyExclusiveStartKey.getRangeKeyElement()) != null) {
                    jsonWriter.key("RangeKeyElement").object();
                    if (attributeValueRangeKeyElement.getS() != null) {
                        jsonWriter.key("S").value(attributeValueRangeKeyElement.getS());
                    }
                    if (attributeValueRangeKeyElement.getN() != null) {
                        jsonWriter.key("N").value(attributeValueRangeKeyElement.getN());
                    }
                    if (attributeValueRangeKeyElement != null) {
                        sSList = attributeValueRangeKeyElement.getSS();
                        int sSListIndex = 0;
                        if (sSList != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                if (sSListValue != null) {
                                    jsonWriter.value(sSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++sSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    if (attributeValueRangeKeyElement != null) {
                        nSList = attributeValueRangeKeyElement.getNS();
                        int nSListIndex = 0;
                        if (nSList != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                if (nSListValue != null) {
                                    jsonWriter.value(nSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++nSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

