/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.norbl.cbp.ppe.InstanceStatus;
import com.norbl.cbp.ppe.NoSuchNetworkException;
import com.norbl.cbp.ppe.Pinger;
import com.norbl.cbp.ppe.Services;
import com.norbl.util.ssh.SshPingFailureException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NetworkInfo
implements Comparable {
    private Services services;
    String name;
    String ID;
    public List<InstanceStatus> instances;
    private State state;
    private boolean endogenousNetwork;

    public NetworkInfo(String ID, String name) {
        this.name = name;
        this.ID = ID;
        this.instances = new ArrayList<InstanceStatus>();
        this.state = State.nil;
        this.services = Services.createServices(ID);
        this.endogenousNetwork = true;
    }

    public void setEndogeous(boolean isEndog) {
        this.endogenousNetwork = isEndog;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setState() {
        if (State.rebooting.equals((Object)this.state)) {
            return;
        }
        if (this.endogenousNetwork) {
            if (this.instances.size() < 1) {
                return;
            }
            this.state = this.findStateFromInstances();
            if (!State.running.equals((Object)this.state)) {
                return;
            }
            if (this.services.isRunning()) {
                return;
            }
            if (this.services.isPending()) {
                this.state = State.servicesPending;
            } else if (this.services.notRunning()) {
                this.state = State.servicesNotRunning;
            }
        } else {
            this.state = this.findStateFromInstances();
        }
    }

    public Services getServices() {
        return this.services;
    }

    public boolean isPending() {
        return State.pending.equals((Object)this.state);
    }

    public boolean isRunning() {
        return State.running.equals((Object)this.state);
    }

    public boolean isShuttingDown() {
        return State.shuttingDown.equals((Object)this.state);
    }

    public boolean isTerminated() {
        return State.terminated.equals((Object)this.state);
    }

    public boolean isShuttingDownOrTerminated() {
        return this.isShuttingDown() || this.isTerminated();
    }

    public boolean isNil() {
        return State.nil.equals((Object)this.state);
    }

    public boolean isServicesNotRunning() {
        return State.servicesNotRunning.equals((Object)this.state);
    }

    public void setServices(Services services) {
        this.services = services;
    }

    private State findStateFromInstances() {
        int nNil = 0;
        int nPending = 0;
        int nShuttingDown = 0;
        int nRunning = 0;
        int nTerminated = 0;
        for (InstanceStatus ins : this.instances) {
            State s = State.getState(ins.instance.getState().getName());
            if (s == null) {
                ++nNil;
                continue;
            }
            if (State.pending.equals((Object)s)) {
                ++nPending;
                continue;
            }
            if (State.shuttingDown.equals((Object)s)) {
                ++nShuttingDown;
                continue;
            }
            if (State.running.equals((Object)s)) {
                ++nRunning;
                continue;
            }
            if (!State.terminated.equals((Object)s)) continue;
            ++nTerminated;
        }
        if (nPending > 0) {
            return State.pending;
        }
        if (nShuttingDown > 0) {
            return State.shuttingDown;
        }
        if (nRunning >= this.instances.size()) {
            return State.running;
        }
        if (nTerminated >= this.instances.size()) {
            return State.terminated;
        }
        if (nTerminated > 0) {
            return State.shuttingDown;
        }
        return State.nil;
    }

    public String getStateDescription() {
        if (this.endogenousNetwork) {
            if (!State.running.equals((Object)this.state)) {
                return this.state.getTitle();
            }
            if (State.servicesPending.equals((Object)this.state) || State.servicesNotRunning.equals((Object)this.state)) {
                return this.services.getStateTitle();
            }
            if (this.services.inNilState()) {
                return "pending";
            }
            return this.state.getTitle();
        }
        return this.state.getTitle();
    }

    public void add(InstanceStatus s) {
        if (!this.instances.contains(s)) {
            this.instances.add(s);
        }
    }

    public void clearInstances() {
        this.instances.clear();
    }

    public String getNetworkName() {
        return this.name;
    }

    public String getNetworkID() {
        return this.ID;
    }

    public int getNActiveInstances() {
        int n = 0;
        for (InstanceStatus ins : this.instances) {
            if (!ins.isActive()) continue;
            ++n;
        }
        return n;
    }

    public String getMastersPublicDnsName() {
        for (InstanceStatus instance : this.instances) {
            if (!instance.isMaster()) continue;
            return instance.getPublicDnsName();
        }
        return null;
    }

    public int compareTo(Object other) {
        return this.name.compareTo(((NetworkInfo)other).name);
    }

    public String toString() {
        return this.name + " " + this.ID + " n instances=" + this.instances.size() + " " + this.getStateDescription();
    }

    public long getLaunchTime() {
        long lt = Long.MAX_VALUE;
        for (InstanceStatus s : this.instances) {
            Date d = s.instance.getLaunchTime();
            long tm = d.getTime();
            if (tm >= lt) continue;
            lt = tm;
        }
        return lt;
    }

    public void pingAllInstances() throws NoSuchNetworkException, SshPingFailureException {
        Pinger.waitForPingsFromAllHosts(this.getNetworkID(), 240000L);
    }

    private static enum ServiceState {
        running,
        pending,
        nil;

    }

    public static enum State {
        nil("-", ""),
        spotRequestPending("spot request pending", ""),
        pending("instances pending", "pending"),
        running("running", "running"),
        servicesPending("services pending", ""),
        servicesNotRunning("services not running", ""),
        shuttingDown("shutting down", "shutting down"),
        terminated("terminated", "terminated"),
        rebooting("rebooting", "rebooting");

        String title;
        String awsStateName;

        private State(String title, String awsStateName) {
            this.title = title;
            this.awsStateName = awsStateName;
        }

        static State getState(String awsInstanceState) {
            for (State s : State.values()) {
                if (!s.awsStateName.equals(awsInstanceState)) continue;
                return s;
            }
            return null;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

