/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.s3.AmazonS3Client;
import com.norbl.cbp.ppe.AmiPPE;
import com.norbl.cbp.ppe.Ec2InstanceType;
import com.norbl.cbp.ppe.ParamHtPPE;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.util.FileUtil;
import com.norbl.util.ParamHt;
import com.norbl.util.aws.S3Access;
import com.norbl.util.aws.SDBAccess;
import com.norbl.util.gui.GuiUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UtilApps {
    public static void main(String[] argv) throws Exception {
        UtilApps.viewAmis("cloudrmpi-ami");
    }

    public static void createOmpiAmiPPEsInS3() throws Exception {
        String groupName = "ppe-ompi-ami";
        AmazonEC2Client ec2Client = UtilApps.getEc2ClientNBL();
        AmazonS3Client s3Client = UtilApps.getS3ClientNBL();
        S3Access s3a = new S3Access(s3Client);
        List<AmiPPE> zcs = AmiPPE.createAmiPPEs(ec2Client, new String[]{"ami-cc629ba5", "ami-eb478182"}, 0.0);
        List<AmiPPE> cs = AmiPPE.createAmiPPEs(ec2Client, new String[]{"ami-7039e219", "ami-3237ec5b"}, 0.03);
        ArrayList<AmiPPE> amis = new ArrayList<AmiPPE>();
        amis.addAll(zcs);
        amis.addAll(cs);
        AmiPPE.uploadAmiPPEs(s3a, groupName, amis);
        System.out.println("Uploaded " + amis.size() + " AmiPPE to s3 object " + groupName);
    }

    public static void createCloudRmpiAmiPPEsInS3() throws Exception {
        String groupName = "cloudrmpi-ami";
        AmazonEC2Client ec2Client = UtilApps.getEc2ClientNBL();
        AmazonS3Client s3Client = UtilApps.getS3ClientNBL();
        S3Access s3a = new S3Access(s3Client);
        List<AmiPPE> zcs = AmiPPE.createAmiPPEs(ec2Client, new String[]{"ami-5608d73f", "ami-58bb6431"}, 0.0);
        List<AmiPPE> cs = AmiPPE.createAmiPPEs(ec2Client, new String[]{"ami-5a04df33", "ami-dc30ebb5"}, 0.03);
        ArrayList<AmiPPE> amis = new ArrayList<AmiPPE>();
        amis.addAll(zcs);
        amis.addAll(cs);
        AmiPPE.uploadAmiPPEs(s3a, groupName, amis);
        System.out.println("Uploaded " + amis.size() + " AmiPPE to s3 object " + groupName);
    }

    public static void viewAmis(String groupName) {
        S3Access s3a = new S3Access();
        List<AmiPPE> amis = AmiPPE.retrieveAmiPPEs(s3a, groupName);
        System.out.println("n ami=" + amis.size());
        for (AmiPPE ami : amis) {
            System.out.println(ami.amiID);
            for (String key : ami.tags.keySet()) {
                System.out.println("    " + key + "=" + ami.tags.get(key));
            }
        }
    }

    public static List<AmiPPE> getAmiData() {
        ArrayList<AmiPPE> amis = new ArrayList<AmiPPE>();
        S3Access s3a = new S3Access();
        for (String gn : new String[]{"ppe-runjrun-ami-zc", "ppe-cloudrmpi-ami-zc"}) {
            amis.addAll(AmiPPE.retrieveAmiPPEs(s3a, gn));
        }
        return amis;
    }

    public static void createOmpiZCs() throws Exception {
        AmiPPE.createAndUploadAmiPPEs("ppe-ompi-ami-zc", new String[]{"ami-cc629ba5", "ami-eb478182"}, 0.0);
    }

    public static void createCloudRmpiZCs() throws Exception {
        AmiPPE.createAndUploadAmiPPEs("ppe-cloudrmpi-ami-zc", new String[]{"ami-5608d73f", "ami-58bb6431"}, 0.0);
    }

    public static void createRunJRunZCs() throws Exception {
        AmiPPE.createAndUploadAmiPPEs("ppe-runjrun-ami-zc", new String[]{"ami-37836d5e"}, 0.0);
    }

    public static AmazonEC2Client getEc2ClientNBL() throws Exception {
        String cf = "/home/moi/eh/aws/nbl_account/nbl.ppe-config";
        ParamHtPPE pht = new ParamHtPPE(new String[]{"configFile=" + cf});
        ParamsEc2 pec2 = new ParamsEc2(pht);
        return new AmazonEC2Client(pec2.buildAWSCredentials());
    }

    public static AmazonS3Client getS3ClientNBL() throws Exception {
        String cf = "/home/moi/eh/aws/nbl_account/nbl.ppe-config";
        ParamHtPPE pht = new ParamHtPPE(new String[]{"configFile=" + cf});
        ParamsEc2 pec2 = new ParamsEc2(pht);
        return new AmazonS3Client(pec2.buildAWSCredentials());
    }

    public static SDBAccess getSDBAccess() throws Exception {
        String cf = "/home/moi/eh/aws/nbl_account/nbl.ppe-config";
        ParamHtPPE pht = new ParamHtPPE(new String[]{"configFile=" + cf});
        ParamsEc2 pec2 = new ParamsEc2(pht);
        return new SDBAccess(pec2);
    }

    public static void writeInstancesTypesToS3() throws Exception {
        ParamHtPPE paramsHt = new ParamHtPPE(new String[]{ParamHt.ParamName.configFile.toString() + "=" + "/home/moi/eh/aws/nbl_account/nbl.ppe-config"});
        ParamsEc2 paramsEc2 = new ParamsEc2(paramsHt);
        S3Access s3a = new S3Access(paramsEc2);
        List<Ec2InstanceType> eits = UtilApps.getInstanceTypesFromFile();
        System.out.println("Read " + eits.size() + " from file.");
        s3a.putObject("norbl-ppe-info", "instance-types", (Serializable)((Object)eits), true);
    }

    public static List<Ec2InstanceType> getInstanceTypesFromFile() throws FileNotFoundException, IOException, NullPointerException {
        File f = new File("/home/moi/h/ppe/data_files/ec2-instance-types");
        return UtilApps.getInstanceTypesFromFile(f);
    }

    private static List<Ec2InstanceType> getInstanceTypesFromFile(File f) throws FileNotFoundException, IOException, NullPointerException {
        if (!f.exists()) {
            throw new RuntimeException("The instance type file, " + f.getPath() + " does not exist.");
        }
        List<String[]> lines = FileUtil.readConfigTypeFile(f, "[ \t]+", "#", 7);
        ArrayList<Ec2InstanceType> iTypes = new ArrayList<Ec2InstanceType>();
        for (String[] ln : lines) {
            try {
                InstanceType instanceType = Ec2InstanceType.getInstanceType(ln[0]);
                iTypes.add(new Ec2InstanceType(instanceType, Integer.parseInt(ln[1]), Double.parseDouble(ln[2]), UtilApps.toBoolean(ln[3]), Ec2InstanceType.VirtualizationType.valueOf(ln[4]), Double.parseDouble(ln[5]), ln[6]));
            }
            catch (IllegalArgumentException ix) {
                GuiUtil.warning(new String[]{"Undefined instance type: " + ln[0], "it will be omitted.", ix.getMessage()}, "Undefined instance type");
            }
        }
        return iTypes;
    }

    private static boolean toBoolean(String s) {
        return "yes".equals(s.trim().toLowerCase());
    }
}

