% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posixt.R
\name{date_time_build}
\alias{date_time_build}
\title{Building: date-time}
\usage{
date_time_build(
  year,
  month = 1L,
  day = 1L,
  hour = 0L,
  minute = 0L,
  second = 0L,
  ...,
  zone,
  invalid = NULL,
  nonexistent = NULL,
  ambiguous = NULL
)
}
\arguments{
\item{year}{\verb{[integer]}

The year. Values \verb{[-32767, 32767]} are generally allowed.}

\item{month}{\verb{[integer]}

The month. Values \verb{[1, 12]} are allowed.}

\item{day}{\verb{[integer / "last"]}

The day of the month. Values \verb{[1, 31]} are allowed.

If \code{"last"}, then the last day of the month is returned.}

\item{hour}{\verb{[integer]}

The hour. Values \verb{[0, 23]} are allowed.}

\item{minute}{\verb{[integer]}

The minute. Values \verb{[0, 59]} are allowed.}

\item{second}{\verb{[integer]}

The second. Values \verb{[0, 59]} are allowed.}

\item{...}{These dots are for future extensions and must be empty.}

\item{zone}{\verb{[character(1)]}

A valid time zone name.

This argument is required, and must be specified by name.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}

\item{nonexistent}{\verb{[character / NULL]}

One of the following nonexistent time resolution strategies, allowed to be
either length 1, or the same length as the input:
\itemize{
\item \code{"roll-forward"}: The next valid instant in time.
\item \code{"roll-backward"}: The previous valid instant in time.
\item \code{"shift-forward"}: Shift the nonexistent time forward by the size of
the daylight saving time gap.
\item \verb{"shift-backward}: Shift the nonexistent time backward by the size of
the daylight saving time gap.
\item \code{"NA"}: Replace nonexistent times with \code{NA}.
\item \code{"error"}: Error on nonexistent times.
}

Using either \code{"roll-forward"} or \code{"roll-backward"} is generally
recommended over shifting, as these two strategies maintain the
\emph{relative ordering} between elements of the input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{nonexistent} must be supplied
and cannot be \code{NULL}. This is a convenient way to make production code
robust to nonexistent times.}

\item{ambiguous}{\verb{[character / zoned_time / POSIXct / list(2) / NULL]}

One of the following ambiguous time resolution strategies, allowed to be
either length 1, or the same length as the input:
\itemize{
\item \code{"earliest"}: Of the two possible times, choose the earliest one.
\item \code{"latest"}: Of the two possible times, choose the latest one.
\item \code{"NA"}: Replace ambiguous times with \code{NA}.
\item \code{"error"}: Error on ambiguous times.
}

Alternatively, \code{ambiguous} is allowed to be a zoned_time (or POSIXct) that
is either length 1, or the same length as the input. If an ambiguous time
is encountered, the zoned_time is consulted. If the zoned_time corresponds
to a naive_time that is also ambiguous \emph{and} uses the same daylight saving
time transition point as the original ambiguous time, then the offset of
the zoned_time is used to resolve the ambiguity. If the ambiguity cannot be
resolved by consulting the zoned_time, then this method falls back to
\code{NULL}.

Finally, \code{ambiguous} is allowed to be a list of size 2, where the first
element of the list is a zoned_time (as described above), and the second
element of the list is an ambiguous time resolution strategy to use when
the ambiguous time cannot be resolved by consulting the zoned_time.
Specifying a zoned_time on its own is identical to \verb{list(<zoned_time>, NULL)}.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{ambiguous} must be supplied and
cannot be \code{NULL}. Additionally, \code{ambiguous} cannot be specified as a
zoned_time on its own, as this implies \code{NULL} for ambiguous times that the
zoned_time cannot resolve. Instead, it must be specified as a list
alongside an ambiguous time resolution strategy as described above. This is
a convenient way to make production code robust to ambiguous times.}
}
\value{
A POSIXct.
}
\description{
\code{date_time_build()} builds a POSIXct from it's individual components.

To build a POSIXct, it is required that you specify the \code{zone}.
}
\details{
Components are recycled against each other.
}
\examples{
# The zone argument is required!
# clock always requires you to be explicit about your choice of `zone`.
try(date_time_build(2020))

date_time_build(2020, zone = "America/New_York")

# Nonexistent time due to daylight saving time gap from 01:59:59 -> 03:00:00
try(date_time_build(1970, 4, 26, 1:12, 30, zone = "America/New_York"))

# Resolve with a nonexistent time resolution strategy
date_time_build(
  1970, 4, 26, 1:12, 30,
  zone = "America/New_York",
  nonexistent = "roll-forward"
)
}
