% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tfa_sample_data_2}
\alias{tfa_sample_data_2}
\title{TFA sample data - 2}
\format{
An object of class \code{"dataframe"}; an example of the
usage in \code{\link[clintools]{TFA}}-function.
}
\source{
\href{https://github.com/lilleoel/clintools}{GitHub}
}
\usage{
data(tfa_sample_data)
}
\description{
Dataframe with data provided by Prof. Simpsons, with time (t), arterial blood pressure (abp), left MCAv (mcav_l), right MCAv (mcav_r), and end-tidal CO2 (etco2).
}
\examples{
data(tfa_sample_data)
TFA(tfa_sample_data_2[,c(1:3)], variables=c("abp","mcav"), freq=10)
}
\references{
\itemize{
\item Simpsons D (2015) (\href{http://www.car-net.org/content/resources}{Cerebral Autoregulation Research Network})
\item Claassen et al. (2016) J Cereb Blood Flow Metab. 2016 Apr;36(4):665-80. (\href{https://pubmed.ncbi.nlm.nih.gov/26782760/}{PubMed})
}
}
\keyword{datasets}
