% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ffm.R
\name{calc_ffm}
\alias{calc_ffm}
\title{Calculate fat-free mass}
\usage{
calc_ffm(weight = NULL, bmi = NULL, sex = NULL, height = NULL,
  age = NULL, method = "green", digits = 1)
}
\arguments{
\item{weight}{total body weight in kg}

\item{bmi}{BMI, only used in `green` method. If `weight` and `height` are both specified, `bmi` will be calculated on-the-fly.}

\item{sex}{sex, either `male` of `female`}

\item{height}{height in cm, only required for `holford` method, can be used instead of `bmi` for `green` method}

\item{age}{age, only used for Storset equation}

\item{method}{estimation method, either `green` (default), `holford`, or `storset`}

\item{digits}{round to number of digits}
}
\description{
Get an estimate of body-surface area based on weight, height, and sex (and age for Storset equation).
}
\details{
References:
`green`: Janmahasatian et al. Clin Pharmacokinet. 2005;44(10):1051-65)
`al-sallami`: Al-Sallami et al. Clin Pharmacokinet 2015
`storset`: Storset E et al. TDM 2016
}
\examples{
calc_ffm(weight = 70, bmi = 25, sex = "male")
calc_ffm(weight = 70, height = 180, age = 40, sex = "female", method = "storset")
}
