% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_flow_unit.R
\name{convert_flow_unit}
\alias{convert_flow_unit}
\title{Convert flow (e.g. clearance) from / to units}
\usage{
convert_flow_unit(value = NULL, from = "l", to = "ml", weight = NULL)
}
\arguments{
\item{value}{flow value}

\item{from}{from flow unit, e.g. `L/hr`.}

\item{to}{to flow unit, e.g. `mL/min`}

\item{weight}{for performing per weight (kg) conversion}
}
\description{
Flow units are expected to be specified as a combination
of volume per time units, potentially specified per kg
body weight, e.g. "mL/min", or "L/hr/kg".
}
\details{
Accepted volume units are "L", "dL", and "mL".
Accepted time units are "min", "hr", and "day". 
The only accepted weight unit is "kg".

The function is not case-sensitive.
}
\examples{

## single values
convert_flow_unit(60, "L/hr", "ml/min")
convert_flow_unit(1, "L/hr/kg", "ml/min", weight = 80)

## vectorized
convert_flow_unit(
  c(10, 20, 30), 
  from = c("L/hr", "mL/min", "L/hr"), 
  to = c("ml/min/kg", "L/hr", "L/hr/kg"), 
  weight = c(70, 80, 90))
  
}
