% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-checkValueType.R
\name{checkValueType}
\alias{checkValueType}
\title{Check if the specified \code{valueType} parameter can be passed to the
\code{branchvalues} of the \code{\link[plotly]{plot_ly}} treemap/sunburst visualizations.}
\usage{
checkValueType(data, vars, valueVar, valueType = "total", labelVars = NULL)
}
\arguments{
\item{data}{Data.frame with data.}

\item{vars}{Character vector with variables of \code{data}
containing plot nodes.
If multiple, they should be specified in hierarchical order (from parent to child node).}

\item{valueVar}{String with numeric variable of \code{data} containing node value,
and associated label.}

\item{valueType}{String with type of values in \code{valueVar}
(\code{branchvalues} of the \code{\link[plotly]{plot_ly}}) function),
among others: 'total' (default, only if sum(child) <= to parent)
or 'relative'.}

\item{labelVars}{Named character vector containing variable labels.}
}
\value{
If the condition is fullfilled:
updated \code{valueType} and warning;
otherwise input \code{valueType}.
}
\description{
If this parameter is set to 'total' and the sum of the counts of the
the children nodes is not bigger than the parent node,
an empty plot is created. In this case, this function
set this parameter to: 'relative'.
}
\author{
Laure Cougnaud
}
