% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainfall.R
\name{rainfall}
\alias{rainfall}
\alias{rainfall.default}
\alias{rainfall.data.frame}
\alias{rainfall.matrix}
\alias{rainfall.sf}
\title{Rainfall indices}
\usage{
rainfall(object, ...)

\method{rainfall}{default}(object, ..., timeseries = FALSE)

\method{rainfall}{data.frame}(object, day.one, span = NULL, ..., timeseries = FALSE)

\method{rainfall}{matrix}(object, day.one, span = NULL, ..., timeseries = FALSE)

\method{rainfall}{sf}(object, day.one, span = NULL, ..., timeseries = FALSE, as.sf = TRUE)
}
\arguments{
\item{object}{a numeric vector with precipitation data or a \code{data.frame}
with geographical coordinates (lonlat), or an object of class \code{sf} 
with geometry 'POINT' or 'POLYGON', or a named \code{matrix} with 
precipitation data. See details.}

\item{...}{additional arguments passed to methods. See details.}

\item{timeseries}{logical, \code{FALSE} for a single point time series
observation or \code{TRUE} for a time series based on \var{intervals}}

\item{day.one}{a vector of class \code{Date} or any other object that can be 
coerced to \code{Date} (e.g. integer, character YYYY-MM-DD) for the starting 
day to capture the climate data}

\item{span}{an integer or a vector with integers (optional if \var{last.day} is 
given) for the length of the time series to be captured}

\item{as.sf}{logical, to return an object of class 'sf'}
}
\value{
A dataframe with rainfall indices:
\item{MLDS}{maximum length of consecutive dry day, rain < 1 mm (days)}
\item{MLWS}{maximum length of consecutive wet days, rain >= 1 mm (days)}
\item{R10mm}{number of heavy precipitation days 10 >= rain < 20 mm (days)}
\item{R20mm}{number of very heavy precipitation days rain >= 20 (days)}
\item{Rx1day}{maximum 1-day precipitation (mm)}
\item{Rx5day}{maximum 5-day precipitation (mm)}
\item{R95p}{total precipitation when rain > 95th percentile (mm)}
\item{R99p}{total precipitation when rain > 99th percentile (mm)}
\item{Rtotal}{total precipitation (mm) in wet days, rain >= 1 (mm)}
\item{SDII}{simple daily intensity index, total precipitation divided by the
 number of wet days (mm/days)}
}
\description{
Methods to compute rainfall indices over a time series
}
\details{
#' Additional arguments:

\code{intervals}: an integer (no lower than 5), for the days intervals when
 \var{timeseries = TRUE}
 
\code{last.day}: optional to \var{span}, an object of class \code{Date} or
 any other object that can be coerced to \code{Date} (e.g. integer, character 
 YYYY-MM-DD)  for the last day of the time series
 
\code{dates}: a character (or Date or numeric) vector for the dates of tmax and tmin
 in the \code{default} method

\code{data.from}: character for the source of remote data. Current remote source 
 is: 'nasapower'

\code{pars}: character vector for the precipitation data to be fetched. If 
 \code{data.from} is 'nasapower', the default precipitation parameter is "PRECTOTCORR".

\code{days.before}: optional, an integer for the number of days before 
 \var{day.one} to be included in the timespan.
 
# S3 Methods 

The \code{matrix} method assumes that \var{object} contains climate data available in
 your R section; see help("rain_dat", package = "climatrends") for an example on input 
 structure.

The \code{data.frame} and the \code{sf} methods assumes that the climate data
 will e fetched from a remote (cloud) source that be adjusted using the argument 
 \var{data.from}.

When \var{timeseries} = \code{TRUE}, an id is created, 
 which is the index for the rownames of the inputted \var{object}.
}
\examples{
# A vector with precipitation data
set.seed(987219)
rain <- runif(50, min = 0, max = 6)

rainfall(rain)

# Return as timeseries with intervals of 7 days
dates <- 17650:17699
rainfall(rain, dates = dates, timeseries = TRUE, intervals = 7)

######################################################

# the matrix method
data("rain_dat", package = "climatrends")

rainfall(rain_dat,
         day.one = "2013-10-28",
         span = 12)


}
\references{
Aguilar E., et al. (2005). Journal of Geophysical Research, 
110(D23), D23107. \doi{https://doi.org/10.1029/2005JD006119}
}
\concept{precipitation functions}
