% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/late_frost.R
\name{late_frost}
\alias{late_frost}
\alias{late_frost.default}
\alias{late_frost.data.frame}
\alias{late_frost.array}
\alias{late_frost.sf}
\title{Late spring frost}
\usage{
late_frost(object, ..., tbase = 4, tfrost = -2)

\method{late_frost}{default}(object, tmin, ..., tbase = 4, tfrost = -2)

\method{late_frost}{data.frame}(object, day.one, ..., tbase = 4, tfrost = -2)

\method{late_frost}{array}(object, day.one, ..., tbase = 4, tfrost = -2)

\method{late_frost}{sf}(object, day.one, ..., tbase = 4, tfrost = -2)
}
\arguments{
\item{object}{a numeric vector with the maximum temperature, 
or a data.frame with geographical coordinates (lonlat), 
or an object of class \code{sf} with geometry 'POINT' or 'POLYGON', 
or an \code{array} with two dimensions containing the
maximum and minimum temperature, in that order. See details}

\item{...}{additional arguments passed to methods. See details}

\item{tbase}{an integer for the minimum temperature for growth}

\item{tfrost}{an integer for the freezing threshold}

\item{tmin}{a numeric vector with the minimum temperature}

\item{day.one}{a vector of class \code{Date} or any other object that can be 
coerced to \code{Date} (e.g. integer, character YYYY-MM-DD) for the starting 
day to capture the climate data}
}
\value{
A data.frame with the late frost events
\item{id}{the id generated using the indices for the rows in \var{object}}
\item{date}{the first day of the event}
\item{gdd}{the growing degree-days accumulated during the event}
\item{event}{a factor for the observed event, frost, latent (where there is no frost event, 
 but also there is no GDD), and warming (where GDD is accumulated)}
\item{duration}{the number of days the event spanned}
}
\description{
Compute late spring frost, which is a freezing event occurring after
 a substantial accumulation of warmth
}
\details{
Additional arguments:

\code{equation}: character to specify the equation to be used, \code{"b"} 
 is set by default. See GDD() 

\code{dates}: a character (or Date or numeric) vector for the dates of tmax and tmin
 in the \code{default} method

\code{last.day}: an object (optional to \var{span}) of class \code{Date} or
 any other object that can be coerced to \code{Date} (e.g. integer, character 
 YYYY-MM-DD) for the last day of the time series
 
\code{span}: an integer (optional to \var{last.day}) or a vector with 
 integers (optional if \var{last.day} is given) for the length of 
 the time series to be captured
}
\examples{
# default method
data("innlandet", package = "climatrends")

# equation b is set by default
# where tmin and tmax are adjusted if below tbase
late_frost(innlandet$tmax, 
           innlandet$tmin, 
           dates = innlandet$date, 
           tbase = 2, 
           tfrost = -2)

# slightly different series if equation a is used
late_frost(innlandet$tmax, 
           innlandet$tmin, 
           dates = innlandet$date, 
           tbase = 2,
           tfrost = -2,
           equation = "a")

#####################################################

# demo of the array method but no frost event is returned 
# because the data comes from the tropics
data("temp_dat", package = "climatrends")

late_frost(temp_dat, day.one = "2013-10-27")

#####################################################

\donttest{
# Some random points in Norway
# get data from NASA Power
library("nasapower")
lonlat <- data.frame(lon = c(10.93, 10.57, 11.21),
                     lat = c(60.77, 61.10, 60.33))

late_frost(lonlat, day.one = "2019-01-01", last.day = "2019-07-01")
     
}

}
\references{
Trnka et al. (2014). Nature Climate Change 4(7):637–43.
\cr\url{https://doi.org/10.1038/nclimate2242}

Zohner et al. (2020). PNAS.
\cr\url{https://doi.org/10.1073/pnas.1920816117}
}
\seealso{
Other GDD functions: 
\code{\link{GDD}()}
}
\concept{GDD functions}
