% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_sensitive.R
\name{crop_sensitive}
\alias{crop_sensitive}
\alias{crop_sensitive.default}
\alias{crop_sensitive.data.frame}
\alias{crop_sensitive.array}
\alias{crop_sensitive.sf}
\title{Crop sensitive indices}
\usage{
crop_sensitive(object, ...)

\method{crop_sensitive}{default}(object, tmin, ...)

\method{crop_sensitive}{data.frame}(object, day.one, ...)

\method{crop_sensitive}{array}(object, day.one, ...)

\method{crop_sensitive}{sf}(object, day.one, ..., as.sf = TRUE)
}
\arguments{
\item{object}{a numeric vector with the maximum temperature, 
or a data.frame with geographical coordinates (lonlat), 
or an object of class \code{sf} with geometry 'POINT' or 'POLYGON', 
or an \code{array} with two dimensions containing the
maximum and minimum temperature, in that order. See details}

\item{...}{additional arguments passed to methods. See details}

\item{tmin}{a numeric vector with the minimum temperature}

\item{day.one}{a vector of class \code{Date} or any other object that can be 
coerced to \code{Date} (e.g. integer, character YYYY-MM-DD) for the starting 
day to capture the climate data}

\item{as.sf}{logical, to return an object of class 'sf'}
}
\value{
A dataframe with crop sensitive indices with n colunms depending on the 
 number of thresholds passed to each index:
\item{hts_mean}{high temperature stress using daily MEAN temperature, 
 and given as percentage number of days a certain threshold is exceeded}
\item{hts_max}{high temperature stress using daily MAX temperature,
 and given as percentage number of days a certain threshold is exceeded}
\item{hse}{heat stress event, and given as percentage number of days a 
 a certain threshold is exceeded for at least two consecutive days}
\item{hse_ms}{heat stress event, and given the maximum number of days 
 a certain threshold is exceeded for at least two consecutive days}
\item{cdi_mean}{crop duration index using daily MEAN temperature, 
 and given as max(Tmean - threshold, 0)}
\item{cdi_max}{crop duration index using daily MAX temperature, 
 and given as max(Tmax - threshold, 0)}
\item{lethal}{lethal temperatures, defined as percentage of days during the 
 timeseries where daily MEAN temperature exceeds a given threshold}
}
\description{
Compute crop sensitive indices. These indices are intended to capture 
 the changes in temperature extremes during key phenological stages 
 (e.g. anthesis), but can also be applied to other phenological stages.
}
\details{
The function uses pre-defined threshold to compute the indices. For hts_mean (32,
 35, 38 Celsius), for hts_max (36, 39, 42 Celsius), for hse (31 Celsius), for 
 cdi_mean (22, 23, 24 Celsius), for cdi_max (27, 28, 29 Celsius) and for 
 lethal (43, 46, 49 Celsius). 

Additional arguments:

The thresholds can be adjusted using the arguments \code{hts_mean.threshold}, 
 \code{hts_max.threshold}, \code{hse.threshold}, \code{cdi_mean.threshold}, 
 \code{cdi_max.threshold} and \code{lethal.threshold} which are a numeric (or
 vector of numeric)

\code{last.day}: an object (optional to \var{span}) of class \code{Date} or
 any other object that can be coerced to \code{Date} (e.g. integer, character 
 YYYY-MM-DD) for the last day of the time series. For \code{data.frame}, \code{array} 
 and \code{sf} methods
 
\code{span}: an integer (optional to \var{last.day}) or a vector with 
 integers (optional if \var{last.day} is given) for the length of 
 the time series to be captured. For \code{data.frame}, \code{array} 
 and \code{sf} methods
}
\examples{
# the default method
set.seed(78)
tmax <- runif(50, 37, 47)
set.seed(79)
tmin <- runif(50, 31, 34)

crop_sensitive(tmax, tmin)

###############################################

# the array method
data("temp_dat", package = "climatrends")

# use the default thresholds
crop_sensitive(temp_dat,
               day.one = "2013-10-27",
               last.day = "2013-11-04")

# or change the thresholds based on the crop physiology
crop_sensitive(temp_dat,
               day.one = "2013-10-27",
               last.day = "2013-11-04",
               hts_mean.threshold = c(24),
               hts_max.threshold = c(31, 33))
}
\references{
Challinor et al. (2016). Nature Climate Change 6(10):6954-958
\cr\url{https://doi.org/10.1038/nclimate3061}

Trnka et al. (2014). Nature Climate Change 4(7):637–43.
\cr\url{https://doi.org/10.1038/nclimate2242}
}
\seealso{
Other temperature functions: 
\code{\link{ETo}()},
\code{\link{GDD}()},
\code{\link{temperature}()}
}
\concept{temperature functions}
