% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogimet_hourly.R
\name{ogimet_hourly}
\alias{ogimet_hourly}
\title{Scrapping hourly meteorological (Synop) data from the Ogimet webpage}
\usage{
ogimet_hourly(
  date = c(Sys.Date() - 30, Sys.Date()),
  coords = FALSE,
  station = 12330,
  precip_split = TRUE,
  allow_failure = TRUE
)
}
\arguments{
\item{date}{start and finish of date (e.g., date = c("2018-05-01","2018-07-01") ); By default last 30 days are taken}

\item{coords}{add geographical coordinates of the station (logical value TRUE or FALSE)}

\item{station}{WMO ID of meteorological station(s). Character or numeric vector}

\item{precip_split}{whether to split precipitation fields into 6/12/24h; default: TRUE}

\item{allow_failure}{logical - whether to proceed or stop on failure. By default set to TRUE (i.e. don't stop on error). For debugging purposes change to FALSE}
}
\value{
data.frame with historical meteorological data for hourly time interval
}
\description{
Downloading hourly (meteorological) data from the Synop stations available in the https://www.ogimet.com/ repository
}
\examples{
\donttest{
  # downloading data for Poznan-Lawica, Poland
  poznan = ogimet_hourly(station = 12330, coords = TRUE)
}

}
\keyword{internal}
