% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfDatatype.R
\name{cfDatatype-class}
\alias{cfDatatype-class}
\alias{cf_datatype}
\alias{cfDatatype}
\title{The Clifro Datatype Object}
\usage{
cf_datatype(select_1 = NA, select_2 = NA, check_box = NA,
  combo_box = NA, graphics = FALSE)
}
\arguments{
\item{select_1}{a numeric vector of first node selections}

\item{select_2}{a numeric vector of second node selections}

\item{check_box}{a list containing the check box selections}

\item{combo_box}{a numeric vector containing the combo box selection
(if applicable)}

\item{graphics}{a logical indicating whether a graphics menu should be used,
if available}
}
\value{
\code{cfDatatype} object
}
\description{
Create a \code{cfDatatype} object by selecting one or more CliFlo datatypes
to build the \pkg{clifro} query.
}
\details{
An object inheriting from the \code{\link{cfDatatype}} class is created by
the constructor function \code{\link{cf_datatype}}. The function allows the
user to choose datatype(s) interactively (if no arguments are given), or to
create datatypes programmatically if the tree menu nodes are known a priori
(see examples). This function uses the same nodes, check box and combo box
options as CliFlo and can be viewed at the
\href{https://cliflo.niwa.co.nz/pls/niwp/wgenf.choose_datatype?cat=cat1}{datatype selection page}.
}
\note{
For the 'public' user (see examples) only the Reefton Ews station data
is available.

Currently clifro does not support datatypes from the special datasets
(Ten minute, Tier2, Virtual Climate, Lysimeter) or upper air measurements
from radiosondes and wind radar.
}
\examples{
\dontrun{
# Select the surface wind datatype manually (unknown tree nodes)
hourly.wind.dt = cf_datatype()
#  2  --> Datatype:        Wind
#  1  --> Datatype 2:      Surface Wind
#  2  --> Options:         Hourly Wind
# (2) --> Another option:  No
#  3  --> Units:           Knots
hourly.wind.dt

# Or select the datatype programatically (using the selections seen above)
hourly.wind.dt = cf_datatype(2, 1, 2, 3)
hourly.wind.dt
}
}
\seealso{
\code{\link{cf_user}} to create a \pkg{clifro} user,
  \code{\link{cf_station}} to choose the CliFlo stations and
  \code{vignette("choose-datatype")} for help choosing \code{cfDatatype}s.
}
