% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{hash_emoji}
\alias{hash_emoji}
\title{Emoji hash}
\usage{
hash_emoji(x, size = 3)
}
\arguments{
\item{x}{Character vector. \code{NA} entries will have an \code{NA} hash.}

\item{size}{Number of emojis to use in a hash. Currently it has to
be between 1 and 4.}
}
\value{
A data frame with columns
\itemize{
\item \code{hash}: the emoji hash, a string of the requested size.
\item \code{emojis}: list column with the emoji characters in character
vectors. Note that an emoji might have multiple code points.
\item \code{text}: text representation of \code{hash}, comma separated.
\item \code{names}: list column with the text representations of \code{emojis}, in
character vectors.
}
}
\description{
Emoji hash
}
\details{
It uses the first 13 hexadecimal characters (out of the 32) of the MD5
hash of the input, and converts them into an emoji representation.
It uses a manually selected subset of all emojis, that tend to be
displayed correctly.
\subsection{Number of possible hash values}{

cli uses 2280 possible emojis. This is the number of
different hashes you can get for different values of \code{size}:\tabular{rr}{
   \code{size} \tab size of hash table space \cr
   1 \tab 2,280 \cr
   2 \tab 5,198,400 \cr
   3 \tab 11,852,352,000 \cr
   4 \tab 27,023,362,560,000 \cr
}

}
}
\examples{
hash_emoji(c("foo", NA, "bar", ""))$text

# if you increase `size`, the shorter hash is a prefix of the longer:
hash_emoji("foobar", 1)$text
hash_emoji("foobar", 2)$text
hash_emoji("foobar", 3)$text
hash_emoji("foobar", 4)$text
}
\seealso{
the emoji package for a comprehensive list of emojis

Other hash functions: 
\code{\link{hash_animal}()},
\code{\link{hash_md5}()}
}
\concept{hash functions}
