% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_substr}
\alias{ansi_substr}
\title{Substring(s) of an ANSI colored string}
\usage{
ansi_substr(x, start, stop)
}
\arguments{
\item{x}{Character vector, potentially ANSI styled, or a vector to
coerced to character.}

\item{start}{Starting index or indices, recycled to match the length
of \code{x}.}

\item{stop}{Ending index or indices, recycled to match the length
of \code{x}.}
}
\value{
Character vector of the same length as \code{x}, containing
the requested substrings. ANSI styles are retained.
}
\description{
This is a color-aware counterpart of \code{\link[base:substr]{base::substr()}}.
It works exactly like the original, but keeps the colors
in the substrings. The ANSI escape sequences are ignored when
calculating the positions within the string.
}
\examples{
str <- paste(
  col_red("red"),
  "default",
  col_green("green")
)

cat(str, "\n")
cat(ansi_substr(str, 1, 5), "\n")
cat(ansi_substr(str, 1, 15), "\n")
cat(ansi_substr(str, 3, 7), "\n")

substr(ansi_strip(str), 1, 5)
substr(ansi_strip(str), 1, 15)
substr(ansi_strip(str), 3, 7)

str2 <- paste(
  "another",
  col_red("multi-", style_underline("style")),
  "text"
)

cat(str2, "\n")
cat(ansi_substr(c(str, str2), c(3,5), c(7, 18)), sep = "\n")
substr(ansi_strip(c(str, str2)), c(3,5), c(7, 18))
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_toupper}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
