% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_and_remove_duplicates.R
\name{remove_duplicates}
\alias{remove_duplicates}
\title{Remove duplicates}
\usage{
remove_duplicates(data, target_columns = NULL)
}
\arguments{
\item{data}{The input \code{<data.frame>} or \code{<linelist>}.}

\item{target_columns}{A \code{<vector>} of column names to use when looking
for duplicates. When the input data is a \code{linelist} object, this
parameter can be set to \code{linelist_tags} if you wish to look for
duplicates on tagged columns only. Default is \code{NULL}.}
}
\value{
The input data \code{<data.frame>} or \code{<linelist>} without the
duplicated rows identified from all or the specified columns.
}
\description{
When removing duplicates, users can specify a set columns to consider with
the \code{target_columns} argument.
}
\examples{
no_dups <- remove_duplicates(
  data = readRDS(
    system.file("extdata", "test_linelist.RDS", package = "cleanepi")
  ),
  target_columns = "linelist_tags"
)


}
