/*
 * Decompiled with CFR 0.152.
 */
package edu.richmond.nlp;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import org.ejml.simple.SimpleMatrix;

public class CSVSentimentDocumentWriter {
    public String docID = "";
    public String header = "";

    public CSVSentimentDocumentWriter(String docID) {
        this.docID = docID;
        this.header = String.format("id,sid,pred_class,p0,p1,p2,p3,p4%n", new Object[0]);
    }

    public String print(CoreMap sentence) {
        StringBuilder sb = new StringBuilder();
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        Tree sentimentTree = (Tree)sentence.get(SentimentCoreAnnotations.SentimentAnnotatedTree.class);
        if (sentimentTree != null) {
            Integer predClass = RNNCoreAnnotations.getPredictedClass((Tree)sentimentTree);
            String predClassString = predClass == null ? "NA" : predClass.toString();
            SimpleMatrix sm = RNNCoreAnnotations.getPredictions((Tree)sentimentTree);
            sb.append(String.format("%s,%d,%s,%f,%f,%f,%f,%f%n", this.docID, ((CoreLabel)tokens.get(0)).sentIndex(), predClassString, sm.get(0), sm.get(1), sm.get(2), sm.get(3), sm.get(4)));
        }
        return sb.toString();
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }
}

