% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cld2.R
\name{cld2}
\alias{cld2}
\alias{detect_language}
\alias{detect_language_mixed}
\alias{detect_language_multi}
\title{Compact Language Detector 2}
\usage{
detect_language(text, plain_text = TRUE, lang_code = TRUE)

detect_language_mixed(text, plain_text = TRUE)
}
\arguments{
\item{text}{a string with text to classify or a connection to read from}

\item{plain_text}{if \code{FALSE} then code skips HTML tags and expands HTML entities}

\item{lang_code}{return a language code instead of name}
}
\description{
The function \code{\link[=detect_language]{detect_language()}} is vectorised and guesses the the language of each string
in \code{text} or returns \code{NA} if the language could not reliably be determined. The function
\code{\link[=detect_language_multi]{detect_language_multi()}} is not vectorised and analyses the entire character vector as a
whole. The output includes the top 3 detected languages including the relative proportion
and the total number of text bytes that was reliably classified.
}
\examples{
# Vectorized function
text <- c("To be or not to be?", "Ce n'est pas grave.", "Nou breekt mijn klomp!")
detect_language(text)

\dontrun{
# Read HTML from connection
detect_language(url('http://www.un.org/ar/universal-declaration-human-rights/'), plain_text = FALSE)

# More detailed classification output
detect_language_mixed(
  url('http://www.un.org/fr/universal-declaration-human-rights/'), plain_text = FALSE)

detect_language_mixed(
  url('http://www.un.org/zh/universal-declaration-human-rights/'), plain_text = FALSE)
}
}
