% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctperson.R
\name{ctperson}
\alias{ctperson}
\title{Classical test theory person statistics}
\usage{
ctperson(x, administered = NULL)
}
\arguments{
\item{x}{a data frame or matrix of corrected data (only containing 1s, 0s, and NAs).}

\item{administered}{a logical matrix indicating which items where administered.
The dimensions should be the same as \code{x}. If \code{NULL} all items
are considered administered.}
}
\value{
A data frame with person statistics.
}
\description{
Calculates persons statistics given a data frame (or matrix) of corrected
data. Including sum scores, number of administered items, number of
answered items, proportion of correct items (for dichotomous data),
and mean score by item (for polytomous data).
}
\examples{
# Data preparation
## Corrected data
corr <- correct(x = dichodata, key = dichokey, navalue = NA)
## Random administered matrix
set.seed(1919)
admin <- sample(x = 0:1, size = nrow(corr)*ncol(corr), replace = TRUE, prob = c(.05,.95))
admin <- matrix(data = as.logical(admin),nrow = nrow(corr))
head(admin)


# Person statistics with all items administered
ex1 <- ctperson(x = corr)
head(ex1)

# Person statistics with NOT all items administered
ex2 <- ctperson(x = corr, administered = admin)
head(ex2)

}
