% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_show.R
\name{resource_show}
\alias{resource_show}
\title{Show a resource.}
\usage{
resource_show(
  id,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{id}{(character) Resource identifier.}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Show a resource.
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/",
key = Sys.getenv("CKAN_DEMO_KEY"))

# create a package
(res <- package_create("yellow7"))

# then create a resource
file <- system.file("examples", "actinidiaceae.csv", package = "ckanr")
(xx <- resource_create(package_id = res$id,
                       description = "my resource",
                       name = "bears",
                       upload = file,
                       rcurl = "http://google.com"
))

# show the resource
resource_show(xx$id)


# eg. from the NHM CKAN store
resource_show(id = "05ff2255-c38a-40c9-b657-4ccb55ab2feb",
              url = "http://data.nhm.ac.uk")
}
}
