% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_parallel_tmle.R
\name{setup_parallel_tmle}
\alias{setup_parallel_tmle}
\title{Setup TMLE to run in parallel}
\usage{
setup_parallel_tmle(parallel = "multicore", max_cores = NULL,
  allow_multinode = T, env = .GlobalEnv)
}
\arguments{
\item{parallel}{"multicore", "doParallel", or "doSNOW"}

\item{max_cores}{Restrict how many many cores will be used on a machine,
rather than using all available cores. Useful if each core needs to use a
substantial amount of memory.}

\item{allow_multinode}{If T, will create a multinode cluster if it finds
multiple machines listed in the "SLURM_NODELIST" environmental variable.
If F, it will only use the current node even if multiple nodes are detected.}

\item{env}{Environment in which to save the functions, defaulting to the
global environment. Set to NULL to disable.}
}
\description{
Starts a cluster and sets up TMLE and SuperLearner to use the cluster
so that TMLE is conducted in parallel rather than using only one core.
}
\seealso{
parallelize, tmle_parallel, gen_superlearner
}
