% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cja_get_projects.R
\name{cja_get_projects}
\alias{cja_get_projects}
\title{Get a paginated list of projects in CJA}
\usage{
cja_get_projects(
  includeType = "all",
  expansion = "definition",
  locale = "en_US",
  filterByIds = NULL,
  pagination = "true",
  ownerId = NULL,
  limit = 10,
  page = 0,
  debug = FALSE
)
}
\arguments{
\item{includeType}{Include additional filters not owned by user. Default is "all". Options include: "all" (default) "shared"}

\item{expansion}{Comma-delimited list of additional segment metadata fields to include on response. See Details for all options available}

\item{locale}{Locale - Default: "en_US"}

\item{filterByIds}{Filter list to only include filters in the specified list (comma-delimited list of IDs). This has filtered Ids from tags, approved, favorites and user specified Ids list.}

\item{pagination}{Return paginated results}

\item{ownerId}{Filter list to only include filters owned by the specified imsUserId}

\item{limit}{Number of results per page}

\item{page}{Page number (base 0 - first page is "0")}

\item{debug}{Used to help troubleshoot api call issues. Shows the call and result in the console}
}
\value{
A data frame of projects and corresponding metadata
}
\description{
Retrieves a paginated list of projects, also known as \verb{Workspace Projects}.
}
\details{
\emph{expansion} options can include any of the following:
"shares" "tags" "accessLevel" "modified" "externalReferences" "definition"

\emph{includeType} options can include any of the following:
"all", "shared"
}
\examples{
\dontrun{
cja_get_projects()
}
}
