% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_build.R
\name{annotation_build}
\alias{annotation_build}
\title{Build the annotation in CJA}
\usage{
annotation_build(
  name = NULL,
  description = NULL,
  date_range = c(Sys.Date() - 30, Sys.Date() - 1),
  color = "blue",
  applyToAllReports = FALSE,
  metric_id = NULL,
  metric_compType = NULL,
  filter_id = NULL,
  filter_verb = NULL,
  filter_dimType = NULL,
  filter_terms = NULL,
  filter_compType = NULL,
  create_annotation = TRUE,
  debug = FALSE,
  dataviewId = Sys.getenv("CJA_DATAVIEW_ID")
)
}
\arguments{
\item{name}{This is the name of the new segment (required)}

\item{description}{This is the description of the segment (required)}

\item{date_range}{The date range of the annotation}

\item{color}{Color name string representing the annotation's color. Supported values include 'blue', 'purple', 'green', 'orange', 'red', 'light green', 'pink', 'dark green', and 'yellow'.}

\item{applyToAllReports}{A boolean that determines if the annotation applies to all report suites.}

\item{metric_id}{The id for the metric scope as found in the \code{aw_get_metrics()} and \code{aw_get_calculatedmetrics()} functions.
This needs to be a "list()" array of items.}

\item{metric_compType}{The component type. This is either 'm' for metric or 'cm' for calculated metric. This needs to be a "list()" array of items.}

\item{filter_id}{The id for the metric scope as found in the \code{aw_get_dimensions()} and \code{aw_get_segments()} functions.
This needs to be a "list()" array of items.}

\item{filter_verb}{The verb is the operator of the filter. The options include
'equals', 'equals_any', and 'exists'. If the 'dimension type' is 'enum' or 'ordered_enum' it
can only use one of the verbs, 'equals' or 'exists'. This needs to be a "list()" array of items.}

\item{filter_dimType}{The dimension type as defined by the 'type' column in \code{aw_get_dimensions()} if it is a dimension that is being
used or it is blank because it is a segment. If it is a segment make sure to include an, "''", empty list item. This needs to be a "list()" array of items}

\item{filter_terms}{If the verb is "equals_any" then this argument should contain a list of values.
If the verb is "equals" then the argument should be a single item. This needs to be a "list()" array of list items.}

\item{filter_compType}{The component type is either a 'd' (dimension) or an 's' (segemnt).
This needs to be a "list()" array of items.}

\item{create_annotation}{Default is TRUE. Set this to FALSE if you want to get the json string that hte function
creates.}

\item{debug}{This enables the api call information to show in the console for
help with debugging issues. default is FALSE}

\item{dataviewId}{\emph{Required} The id of the dataview for which to retrieve dimensions. If an environment variable called \code{CJA_DATAVIEW_ID} exists
in \code{.Renviron} or elsewhere and no \code{dataviewId} argument is provided, then the \code{CJA_DATAVIEW_ID} value will
be used. Use \code{\link[=cja_get_dataviews]{cja_get_dataviews()}} to get a list of available \code{dataviewId}.}
}
\value{
An id of the newly created annotation
}
\description{
This function builds an annotation in Customer Journey Analytics
}
