% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{services_put}
\alias{services_put}
\title{Replace all attributes of this Service}
\usage{
services_put(
  id,
  name = NULL,
  description = NULL,
  docker_image_name = NULL,
  docker_image_tag = NULL,
  schedule = NULL,
  replicas = NULL,
  max_replicas = NULL,
  instance_type = NULL,
  memory = NULL,
  cpu = NULL,
  credentials = NULL,
  permission_set_id = NULL,
  git_repo_url = NULL,
  git_repo_ref = NULL,
  git_path_dir = NULL,
  environment_variables = NULL,
  notifications = NULL,
  partition_label = NULL
)
}
\arguments{
\item{id}{integer required. The ID for this Service.}

\item{name}{string optional. The name of this Service.}

\item{description}{string optional. The description of this Service.}

\item{docker_image_name}{string optional. The name of the docker image to pull from DockerHub.}

\item{docker_image_tag}{string optional. The tag of the docker image to pull from DockerHub (default: latest).}

\item{schedule}{list optional. A list containing the following elements: 
\itemize{
\item runtimePlan string, Only affects the service when deployed. On Demand means that the service will be turned on when viewed and automatically turned off after periods of inactivity.  Specific Times means the service will be on when scheduled. Always On means the deployed service will always be on.
\item recurrences array, List of day-hour combinations this item is scheduled for
}}

\item{replicas}{integer optional. The number of Service replicas to deploy. When maxReplicas is set, this field defines the minimum number of replicas to deploy.}

\item{max_replicas}{integer optional. The maximum number of Service replicas to deploy. Defining this field enables autoscaling.}

\item{instance_type}{string optional. The EC2 instance type to deploy to.}

\item{memory}{integer optional. The amount of memory allocated to each replica of the Service.}

\item{cpu}{integer optional. The amount of cpu allocated to each replica of the the Service.}

\item{credentials}{array optional. A list of credential IDs to pass to the Service.}

\item{permission_set_id}{integer optional. The ID of the associated permission set, if any.}

\item{git_repo_url}{string optional. The url for the git repo where the Service code lives.}

\item{git_repo_ref}{string optional. The git reference to use when pulling code from the repo.}

\item{git_path_dir}{string optional. The path to the Service code within the git repo. If unspecified, the root directory will be used.}

\item{environment_variables}{list optional. Environment Variables to be passed into the Service.}

\item{notifications}{list optional. A list containing the following elements: 
\itemize{
\item failureEmailAddresses array, Addresses to notify by e-mail when the service fails.
\item failureOn boolean, If failure email notifications are on
}}

\item{partition_label}{string optional. The partition label used to run this object.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for this Service.}
\item{name}{string, The name of this Service.}
\item{description}{string, The description of this Service.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{type}{string, The type of this Service}
\item{dockerImageName}{string, The name of the docker image to pull from DockerHub.}
\item{dockerImageTag}{string, The tag of the docker image to pull from DockerHub (default: latest).}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item runtimePlan string, Only affects the service when deployed. On Demand means that the service will be turned on when viewed and automatically turned off after periods of inactivity.  Specific Times means the service will be on when scheduled. Always On means the deployed service will always be on.
\item recurrences array, List of day-hour combinations this item is scheduled for
}}
\item{timeZone}{string, }
\item{replicas}{integer, The number of Service replicas to deploy. When maxReplicas is set, this field defines the minimum number of replicas to deploy.}
\item{maxReplicas}{integer, The maximum number of Service replicas to deploy. Defining this field enables autoscaling.}
\item{instanceType}{string, The EC2 instance type to deploy to.}
\item{memory}{integer, The amount of memory allocated to each replica of the Service.}
\item{cpu}{integer, The amount of cpu allocated to each replica of the the Service.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{credentials}{array, A list of credential IDs to pass to the Service.}
\item{permissionSetId}{integer, The ID of the associated permission set, if any.}
\item{gitRepoUrl}{string, The url for the git repo where the Service code lives.}
\item{gitRepoRef}{string, The git reference to use when pulling code from the repo.}
\item{gitPathDir}{string, The path to the Service code within the git repo. If unspecified, the root directory will be used.}
\item{reportId}{integer, The ID of the associated report.}
\item{currentDeployment}{list, A list containing the following elements: 
\itemize{
\item deploymentId integer, The ID for this deployment.
\item userId integer, The ID of the owner.
\item host string, Domain of the deployment.
\item name string, Name of the deployment.
\item dockerImageName string, The name of the docker image to pull from DockerHub.
\item dockerImageTag string, The tag of the docker image to pull from DockerHub (default: latest).
\item displayUrl string, A signed URL for viewing the deployed item.
\item instanceType string, The EC2 instance type requested for the deployment.
\item memory integer, The memory allocated to the deployment, in MB.
\item cpu integer, The cpu allocated to the deployment, in millicores.
\item state string, The state of the deployment.
\item stateMessage string, A detailed description of the state.
\item maxMemoryUsage number, If the deployment has finished, the maximum amount of memory used during the deployment, in MB.
\item maxCpuUsage number, If the deployment has finished, the maximum amount of cpu used during the deployment, in millicores.
\item createdAt string, 
\item updatedAt string, 
\item serviceId integer, The ID of owning Service
}}
\item{currentUrl}{string, The URL that the service is hosted at.}
\item{environmentVariables}{list, Environment Variables to be passed into the Service.}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item failureEmailAddresses array, Addresses to notify by e-mail when the service fails.
\item failureOn boolean, If failure email notifications are on
}}
\item{partitionLabel}{string, The partition label used to run this object.}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{archived}{string, The archival status of the requested item(s).}
\item{hidden}{boolean, The hidden status of the item.}
}
\description{
Replace all attributes of this Service
}
