% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{files_put}
\alias{files_put}
\title{Update details about a file}
\usage{
files_put(id, name, expires_at)
}
\arguments{
\item{id}{integer required. The ID of the file.}

\item{name}{string required. The file name. The extension must match the previous extension.}

\item{expires_at}{string required. The date and time the file will expire.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the file.}
\item{name}{string, The file name.}
\item{createdAt}{string, The date and time the file was created.}
\item{fileSize}{integer, The file size.}
\item{expiresAt}{string, The date and time the file will expire. If not specified, the file will expire in 30 days. To keep a file indefinitely, specify null.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{downloadUrl}{string, A JSON string containing information about the URL of the file.}
\item{fileUrl}{string, The URL that may be used to download the file.}
\item{detectedInfo}{list, A list containing the following elements: 
\itemize{
\item includeHeader boolean, A boolean value indicating whether or not the first row of the file is a header row.
\item columnDelimiter string, The column delimiter for the file. One of "comma", "tab", or "pipe".
\item compression string, The type of compression of the file. One of "gzip", or "none".
\item tableColumns array, An array of hashes corresponding to the columns in the file. Each hash should have keys for column "name" and "sql_type"
}}
}
\description{
Update details about a file
}
