% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{groups_list}
\alias{groups_list}
\title{List Groups}
\usage{
groups_list(
  query = NULL,
  permission = NULL,
  include_members = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{query}{string optional. If specified, it will filter the groups returned. Infix matching is supported (e.g., "query=group" will return "group" and "group of people" and "my group" and "my group of people").}

\item{permission}{string optional. A permissions string, one of "read", "write", or "manage". Lists only groups for which the current user has that permission.}

\item{include_members}{boolean optional. Show members of the group.}

\item{limit}{integer optional. Number of results to return. Defaults to 50. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to name. Must be one of: name, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of this group.}
\item{name}{string, This group's name.}
\item{createdAt}{string, The date and time when this group was created.}
\item{slug}{string, The slug for this group.}
\item{organizationId}{integer, The ID of the organization this group belongs to.}
\item{organizationName}{string, The name of the organization this group belongs to.}
\item{memberCount}{integer, The total number of members in this group.}
\item{members}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
}
\description{
List Groups
}
