% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{apps_list_instances}
\alias{apps_list_instances}
\title{List the instances of a Decision Application}
\usage{
apps_list_instances(slug, archived = NULL, app_release_id = NULL,
  limit = NULL, page_num = NULL, order = NULL, order_dir = NULL)
}
\arguments{
\item{slug}{string required. The slug for the application.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{app_release_id}{integer optional. If supplied, return only instances matching this release.}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The unique id of the instance.}
\item{name}{string, The name of the instance.}
\item{appReleaseId}{integer, The id of the app release the instance belongs to.}
\item{reportId}{integer, The id of the report the instance belongs to.}
\item{createdAt}{string, The time the instance was created at.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{projectId}{integer, The id of the project collecting all the items that belong to this app instance.}
}
\description{
List the instances of a Decision Application
}
