% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instrument_oop.R
\name{scales}
\alias{scales}
\title{Display the scales of a circumplex instrument}
\usage{
scales(x, items = FALSE)
}
\arguments{
\item{x}{Required. An object of the instrument class.}

\item{items}{Optional. A logical determining whether the items for each scale
should be displayed below its other information (default = FALSE).}
}
\value{
The same input object. Prints text to console.
}
\description{
Display the scales of a circumplex instrument including the total number of
scales and each scale's abbreviation, hypothetical angle, and text label.
}
\examples{
instrument("csip")
scales(csip)
scales(csip, items = TRUE)
}
\seealso{
Other instrument functions: 
\code{\link{anchors}()},
\code{\link{instrument}()},
\code{\link{instruments}()},
\code{\link{items}()},
\code{\link{norms}()}
}
\concept{instrument functions}
