% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolarPlotData.R
\name{PolarPlotData}
\alias{PolarPlotData}
\title{Polar plot of circular data}
\usage{
PolarPlotData(
  Data,
  drc,
  thr = NULL,
  ylim = NULL,
  pointSize = 1,
  fontSize = 12,
  thrWidth = 4,
  thrColor = "#D45E1A"
)
}
\arguments{
\item{Data}{Response variable}

\item{drc}{Directional covariate}

\item{thr}{Threshold values along thetaGrid}

\item{ylim}{Range of values}

\item{pointSize}{Size of points (observations)}

\item{fontSize}{Font size}

\item{thrWidth}{Threshold width}

\item{thrColor}{Threshold colour}
}
\value{
Polar plot of circular data, possibly including a threshold
}
\description{
Polar plot of circular data
}
\examples{
data(HsSP)
data(drc)

PolarPlotData(Data=HsSP, drc=drc, thr=NULL, pointSize=4, fontSize=14,
              thrWidth=4, ylim=c(0,max(HsSP)))

data(thresholdExampleML) # loads threshold example

PolarPlotData(Data=HsSP, drc=drc, thr=thresholdExampleML, pointSize=4,
              fontSize=12, thrWidth=4, ylim=c(0,max(HsSP)))
}
