% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassFunctions.R
\name{mcmc_summary.circGLM}
\alias{mcmc_summary.circGLM}
\title{Obtain different central tendencies and CIs from a circGLM object}
\usage{
mcmc_summary.circGLM(m, modebw = 0.1, ciperc = 0.95)
}
\arguments{
\item{m}{A \code{circGLM} object.}

\item{modebw}{Numeric between 0 and 1. The modes are estimated by taking the
midpoint of a highest density interval. Specifically, the mode is the
midpoint of the interval that contains \code{modebw} of the density of the
posterior. Reasonable values are roughly between .005 and .2, although
lower values may be reasonable if the number of iterations, Q, is large.}

\item{ciperc}{The confidence interval percentage.}
}
\value{
A matrix with the parameters as rows, and on the columns central
  tendencies and appropriate credible intervals (circular quantiles and
  Highest Density Intervals).
}
\description{
Computes the mean (arithmetic or mean direction), median, and mode estimate
for the MCMC chains of a \code{circGLM} object, as well as a credible
interval.
}
\details{
The summary statistics computed have to be computed differently for linear
and circular variables.
}
\examples{
dat <- generateCircGLMData()
m   <- circGLM(th ~ ., dat)
mcmc_summary.circGLM(m)

}
