% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_gifti.R
\name{write_surf_gifti}
\alias{write_surf_gifti}
\alias{write_surf}
\title{Write a \code{"surf"} to a GIFTI surface file}
\usage{
write_surf_gifti(
  x,
  gifti_fname,
  hemisphere = c("left", "right"),
  encoding = NULL,
  endian = c("LittleEndian", "BigEndian")
)

write_surf(
  x,
  gifti_fname,
  hemisphere = c("left", "right"),
  encoding = NULL,
  endian = c("LittleEndian", "BigEndian")
)
}
\arguments{
\item{x}{A \code{"surf"} object, an object from \code{gifti::readgii}, or a
list with elements "pointset" and "triangle".}

\item{gifti_fname}{Where to write the GIFTI file.}

\item{hemisphere}{"left" (default) or "right". Ignored if \code{data} is already
a "gifti" object, or if it is a \code{"surf"} object with the hemisphere metadata
already specified.}

\item{encoding}{A length-2 vector with elements chosen among "ASCII",
"Base64Binary", and "GZipBase64Binary". If \code{NULL} (default), will use
the metadata if \code{data} is a "gifti" object, or "GZipBase64Binary" for the
"pointset" and "ASCII" for the "triangles" if \code{data} is not already
a GIFTI.}

\item{endian}{"LittleEndian" (default) or "BigEndian".}
}
\value{
Whether the GIFTI was successfully written
}
\description{
Write the data for the left or right surface to a surface GIFTI file.
}
\seealso{
Other functions for writing CIFTI or GIFTI data: 
\code{\link{separate_cifti}()},
\code{\link{write_cifti}()},
\code{\link{write_metric_gifti}()},
\code{\link{write_subcort_nifti}()}

Other functions for working with GIFTI surface geometry data: 
\code{\link{is.surf}()},
\code{\link{read_surf}()},
\code{\link{resample_surf}()},
\code{\link{rotate_surf}()},
\code{\link{view_surf}()}
}
\concept{surfing}
\concept{writing}
