% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_cifti.R
\name{smooth_cifti}
\alias{smooth_cifti}
\alias{smoothCIfTI}
\alias{smoothcii}
\alias{smooth_xifti}
\title{Smooth CIFTI data}
\usage{
smooth_cifti(
  x,
  cifti_target_fname = NULL,
  surf_FWHM = 5,
  vol_FWHM = 3,
  surfL_fname = NULL,
  surfR_fname = NULL,
  cerebellum_fname = NULL,
  subcortical_zeroes_as_NA = FALSE,
  cortical_zeroes_as_NA = FALSE,
  subcortical_merged = FALSE
)

smoothCIfTI(
  x,
  cifti_target_fname = NULL,
  surf_FWHM = 5,
  vol_FWHM = 5,
  surfL_fname = NULL,
  surfR_fname = NULL,
  cerebellum_fname = NULL,
  subcortical_zeroes_as_NA = FALSE,
  cortical_zeroes_as_NA = FALSE,
  subcortical_merged = FALSE
)

smoothcii(
  x,
  cifti_target_fname = NULL,
  surf_FWHM = 5,
  vol_FWHM = 5,
  surfL_fname = NULL,
  surfR_fname = NULL,
  cerebellum_fname = NULL,
  subcortical_zeroes_as_NA = FALSE,
  cortical_zeroes_as_NA = FALSE,
  subcortical_merged = FALSE
)

smooth_xifti(
  x,
  cifti_target_fname = NULL,
  surf_FWHM = 5,
  vol_FWHM = 5,
  surfL_fname = NULL,
  surfR_fname = NULL,
  cerebellum_fname = NULL,
  subcortical_zeroes_as_NA = FALSE,
  cortical_zeroes_as_NA = FALSE,
  subcortical_merged = FALSE
)
}
\arguments{
\item{x}{The CIFTI file name or \code{"xifti"} object to smooth.}

\item{cifti_target_fname}{File name for the smoothed CIFTI. If
\code{NULL}, will be written to "smoothed.d*.nii" in the current working
directory if \code{x} was a CIFTI file, and in a temporary directory if
\code{x} was a \code{"xifti"} object.}

\item{surf_FWHM, vol_FWHM}{The full width at half maximum (FWHM) parameter
for the gaussian surface or volume smoothing kernel, in mm. Default: \code{5}
for cortex (surface) and \code{3} for subcortex (volume).}

\item{surfL_fname, surfR_fname}{(Required if the corresponding cortex is
present) Surface GIFTI files for the left and right cortical surfaces. If not
provided, the default surfaces will be used.}

\item{cerebellum_fname}{(Optional) Surface GIFTI file for the cerebellar surface}

\item{subcortical_zeroes_as_NA, cortical_zeroes_as_NA}{Should zero-values in
the subcortical volume or cortex be treated as NA? Default: \code{FALSE}.}

\item{subcortical_merged}{Smooth across subcortical structure boundaries?
Default: \code{FALSE}.}
}
\value{
The \code{cifti_target_fname}, invisibly, if \code{x} was a CIFTI
file name. A \code{"xifti"} object if \code{x} was a \code{"xifti"} object.
}
\description{
Spatially smooth the metric data of a CIFTI file or \code{"xifti"} object.
}
\details{
If the CIFTI is a ".dlabel" file (intent 3007), then it will be converted
to a ".dscalar" file because the values will no longer be integer indices.
Unless the label values were ordinal, this is probably not desired so a
warning will be printed.

Can accept a \code{"xifti"} object as well as a path to a CIFTI-file.

Surfaces are required for each hemisphere in the CIFTI. If they are not
provided, the default inflated surfaces will be used.

Conversion for sigma: \eqn{\sigma * 2 * sqrt(2*log(2)) = FWHM}
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-cifti-smoothing"} Workbench command.
}

\seealso{
Other commonly-used functions: 
\code{\link{is.cifti}()},
\code{\link{read_cifti}()},
\code{\link{resample_cifti}()},
\code{\link{view_xifti_surface}()},
\code{\link{view_xifti_volume}()},
\code{\link{write_cifti}()}
}
\concept{common}
