% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quantile_negbin.R
\name{add_quantile.negbin}
\alias{add_quantile.negbin}
\title{Quantiles for the Response of a Negative Binomial Regression}
\usage{
\method{add_quantile}{negbin}(tb, fit, p, name = NULL, yhatName = "pred", nSims = 2000, ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{negbin}. Predictions are made with
this object.}

\item{p}{A real number between 0 and 1. Sets the probability level
of the quantiles.}

\item{name}{\code{NULL} or a string. If \code{NULL},
quantiles automatically will be named by \code{add_quantile},
otherwise, they will be named \code{name}.}

\item{yhatName}{A string. Name of the vector of predictions.}

\item{nSims}{A positive integer. Set the number of simulated draws
to use.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values and level
    \emph{p} quantiles attached.
}
\description{
This function is one of the methods of \code{add_quantile}.
}
\details{
Quantiles of Negative Binomial linear models are determined by
\code{add_quantile} through a simulation using \code{arm::sim}.
}
\examples{
x1 <- rnorm(100, mean = 1)
y <- MASS::rnegbin(n = 100, mu = exp(1 + x1), theta = 5)
df <- data.frame(x1 = x1, y = y)
fit <- MASS::glm.nb(y ~ x1, data = df)
add_quantile(df, fit, p = 0.3)

}
\seealso{
\code{\link{add_ci.negbin}} for confidence intervals for
    \code{negbin} objects, \code{\link{add_pi.negbin}} for prediction
    intervals of \code{negbin} objects, and \code{\link{add_probs.negbin}}
    for response probabilities of \code{negbin} objects.
}
