% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanfield.R
\name{run_meanfield}
\alias{run_meanfield}
\title{Mean field model}
\usage{
run_meanfield(mod, init, times, ...)
}
\arguments{
\item{mod}{The cellular automaton model (produced by \code{\link{camodel}}}

\item{init}{The initial landscape, or a vector of covers summing to one, whose length 
is equal to the number of states in the model.}

\item{times}{The points in time for which output is wanted}

\item{...}{other arguments are passed to \code{\link[deSolve]{ode}}}
}
\value{
This function returns the results of the \code{\link[deSolve]{ode}} 
 function, which is a matrix with class 'deSolve'
}
\description{
Run the mean field model corresponding to a cellular automaton
}
\details{
The mean field approximation to a cellular automaton simply describes the dynamics 
   of the global covers using differential equations, assumming that both global 
   and local covers are equal (in \code{chouca} model specifications, this assumes 
   p = q). 
 
 For example, if we consider a model with two states 'a' and 'b' and transitions 
   from and to each other, then the following system of equation is used to describe 
   the variations of the proportions of cells in each state: 
 
 \deqn{\frac{da}{dt} = p_b P(b \to a) - p_a P(a \to b)}{ da/dt = p[b] P(b to a) - p[a] P(a to b)}
 \deqn{\frac{db}{dt} = p_a P(a \to b) - p_b P(b \to a)}{ db/dt = p[a] P(a to b) - p[b] P(b to a)}
 
 Running mean-field approximations is useful to understand general dynamics in the 
   absence of neighborhood interactions between cells, or simply to obtain an 
   fast but approximate simulation of the model. 
 
 Note that this function uses directly the expressions of the probabilities, so any 
   cellular automaton is supported, regardless of whether or not it can be simulated 
   exactly by \code{\link{run_camodel}}.
}
\examples{

if ( requireNamespace("deSolve") ) { 
  # Get the mean-field approximation to the arid vegetation model 
  arid <- ca_library("aridvege") 
  mod <- ca_library("aridvege")
  init <- generate_initmat(mod, rep(1, 3)/3, nrow = 100, ncol = 100)
  times <- seq(0, 128)
  out <- run_meanfield(mod, init, times)
  # This uses the default plot method in deSolve
  plot(out)
  
  # A different model and way to specifiy initial conditions.
  coralmod <- ca_library("coralreef")
  init <- c(ALGAE = 0.2, CORAL = 0.5, BARE = 0.3)
  times <- 10^seq(0, 4, length.out = 64)
  out <- run_meanfield(coralmod, init, times, method = "lsoda")
  plot(out, ylim = c(0, 1))
}

}
