% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deldirVertices.R
\name{deldirVertices}
\alias{deldirVertices}
\title{Extract vertices of Delauny triangles and Dirichelet (Voronoi) tiles.}
\usage{
deldirVertices(sites, rw.data = NULL, rw = NULL, type = "tiles")
}
\arguments{
\item{sites}{Object. Data frame of sites to compute Delauny triangulation and Dirichelet (Voronoi) tessellation with variables "x" and "y".}

\item{rw.data}{Object. Data frame of secondary source of data to set the rectangular window or bounding box: observations, cases, etc. with variables "x" and "y".}

\item{rw}{Numeric. Alternative to rw.data: vector of corners to define the rectangular window or bounding box: xmin, xmax, ymin, ymax.}

\item{type}{Character. "tiles" (tessellation) or "triangles" (triangulation) vertices.}
}
\value{
An R list of data frames of vertices.
}
\description{
For use with functions that use polygons.
}
\note{
This function relies on the 'deldir' package.
}
\examples{
vertices <- deldirVertices(pumps)
snowMap()
invisible(lapply(vertices, polygon))

vertices <- deldirVertices(pumps, roads)
snowMap()
invisible(lapply(vertices, polygon))

vertices <- deldirVertices(pumps, roads, type = "triangles")
snowMap()
invisible(lapply(vertices, polygon))
}
