% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addKernelDensity.R
\name{addKernelDensity}
\alias{addKernelDensity}
\title{Add 2D kernel density contours.}
\usage{
addKernelDensity(pump.subset = "pooled", pump.select = NULL,
  neighborhood.type = "walking", obs.unit = "unstacked", bandwidth = 0.5,
  color = "black", line.type = "solid", multi.core = FALSE, ...)
}
\arguments{
\item{pump.subset}{Character or Numeric: "pooled", "individual", or numeric vector of observed pump neighborhoods (3 through 12 or [3, 12]). The vector of pumps to select (subset) from neighborhoods defined by "pump.select". Negative selection possible.}

\item{pump.select}{Numeric. Vector of pumps to consider. This creates a scenario where the only pumps are those in the vector (negative selection possible).}

\item{neighborhood.type}{Character. "voronoi" or "walking"}

\item{obs.unit}{Character. Unit of observation. "unstacked" uses \code{fatalities.unstacked}. "address" uses \code{fatalities.address}. "fatality" uses \code{fatalities}.}

\item{bandwidth}{Numeric. Bandwidth for kernel density estimation.}

\item{color}{Character. Color of contour lines.}

\item{line.type}{Character. Line type for contour lines.}

\item{multi.core}{Logical or Numeric. TRUE uses parallel::detectCores(). FALSE uses one, single core. You can also specify the number logical cores. On Window, only "multi.core = FALSE" is available.}

\item{...}{Additional plotting parameters.}
}
\value{
Add contours to a graphics plot.
}
\description{
Uses KernSmooth::bkde2D().
}
\examples{
# snowMap()
# addKernelDensity()

# snowMap()
# addKernelDensity("individual")

# snowMap()
# addKernelDensity(c(6, 8))

# snowMap()
# addKernelDensity(pump.select = c(6, 8))
}
\seealso{
\code{\link{snowMap}},
\code{\link{addIndexCase}},
\code{\link{addLandmarks}},
\code{\link{addPlaguePit}},
\code{\link{addSnow}},
\code{\link{addVoronoi}},
\code{\link{addWhitehead}}
}
