% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-file.R
\name{chk_file}
\alias{chk_file}
\alias{vld_file}
\title{Check File Exists}
\usage{
chk_file(x, x_name = NULL)

vld_file(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} functions throw an informative error if the test fails.

The \code{vld_} functions return a flag indicating whether the test was met.
}
\description{
Checks if file exists using

\code{vld_string(x) && file.exists(x) && !dir.exists(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_file}: Validate File Exists
}}

\examples{

# chk_file
try(chk_file(tempfile()))

# vld_file
vld_file(tempfile())
}
\seealso{
Other chk_files: 
\code{\link{chk_dir}()},
\code{\link{chk_ext}()}
}
\concept{chk_files}
