% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{abort_chk}
\alias{abort_chk}
\title{Abort Check}
\usage{
abort_chk(..., n = NULL, tidy = TRUE)
}
\arguments{
\item{...}{Multiple objects that are converted to a string using
\code{paste0(..., collapse = '')}.}

\item{n}{The value of n for converting \code{sprintf}-like types.}

\item{tidy}{A flag specifying whether capitalize the first character and add a missing period.}
}
\value{
Throws an error of class \code{'chk_error'}.
}
\description{
A wrapper on \code{\link[=err]{err()}} that sets the subclass to be \code{'chk_error'}.
}
\details{
It is exported to allow users to easily construct their own \code{chk_} functions.
}
\examples{
try(abort_chk("x must be NULL"))
try(abort_chk("`x` must be NULL"))
try(abort_chk("there \%r \%n problem value\%s", n = 1))
try(abort_chk("there \%r \%n problem value\%s", n = 1.5))
}
\seealso{
\code{\link[=err]{err()}}
}
