% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-identical.R
\name{chk_identical}
\alias{chk_identical}
\alias{vld_identical}
\title{Check Identical}
\usage{
chk_identical(x, y, x_name = NULL)

vld_identical(x, y)
}
\arguments{
\item{x}{The object to check.}

\item{y}{An object to check against.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is identical to y using

\code{identical(x, y)}
}
\section{Functions}{
\itemize{
\item \code{vld_identical}: Validate Identical
}}

\examples{

# chk_identical
chk_identical(1, 1)
try(chk_identical(1, 1L))
chk_identical(c(1, 1), c(1, 1))
try(chk_identical(1, c(1, 1)))

vld_identical(1, 1)
}
\seealso{
Other chk_equal: \code{\link{chk_equal}},
  \code{\link{chk_equivalent}}
}
\concept{chk_equal}
