% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Empirical_temperature_curve.R
\name{Empirical_daily_temperature_curve}
\alias{Empirical_daily_temperature_curve}
\title{Empirical daily temperature curve}
\usage{
Empirical_daily_temperature_curve(Thourly)
}
\arguments{
\item{Thourly}{data.frame containing hourly temperatures. Must contain columns
\code{Year} (year of observation), \code{Month} (month of observation), \code{Day} (day of 
observation), \code{Hour} (hour of observation) and \code{Temp} (Observed temperature).
If multiple observations within an hour are available, these are averaged.}
}
\value{
data.frame containing three columns: \code{Month} (month for which coefficient
applies), \code{Hour} (hour for which coefficient applies) and \code{Prediction_coefficient}
(the coefficient used for empirical temperature prediction). Coefficients
indicate, by what fraction of the daily temperature range the temperature during
the specified hour is above the daily minimum temperature.
}
\description{
This function derives an empirical daily temperature curve from observed hourly
temperature data. The mean temperature during each hour of the day is expressed
as a function of the daily minimum and maximum temperature. This is done
separately for each month of the year. The output is a data.frame that can then
be used with the
\code{\link[=Empirical_hourly_temperatures]{Empirical_hourly_temperatures}}
function to generate hourly temperatures from data on daily minimum (\code{Tmin})
and maximum (\code{Tmax}) temperatures.
}
\examples{
 
Empirical_daily_temperature_curve(Winters_hours_gaps)

}
\author{
Eike Luedeling
}
\keyword{utility}
