% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ael01_nollt.R
\docType{data}
\name{ael01_nollt_main}
\alias{ael01_nollt_main}
\alias{ael01_nollt_pre}
\alias{ael01_nollt}
\title{\code{AEL01_NOLLT} Listing 1 (Default) Glossary of Preferred Terms and Investigator-Specified Terms.}
\format{
An object of class \code{chevron_l} of length 1.
}
\usage{
ael01_nollt_main(
  adam_db,
  dataset = "adae",
  key_cols = c("AEBODSYS", "AEDECOD"),
  disp_cols = "AETERM",
  split_into_pages_by_var = NULL,
  unique_rows = TRUE,
  ...
)

ael01_nollt_pre(
  adam_db,
  dataset = "adae",
  key_cols = c("AEBODSYS", "AEDECOD"),
  disp_cols = "AETERM",
  ...
)

ael01_nollt
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{key_cols}{(\code{character}) names of columns that should be treated as key columns when rendering the listing.
Key columns allow you to group repeat occurrences.}

\item{disp_cols}{(\code{character}) names of non-key columns which should be displayed when the listing is rendered.}

\item{split_into_pages_by_var}{(\code{character} or \code{NULL}) the name of the variable to split the listing by.}

\item{unique_rows}{(\code{flag}) whether to keep only unique rows in listing.}

\item{...}{additional arguments passed to \code{\link[rlistings:listings]{rlistings::as_listing}}.}
}
\value{
the main function returns an \code{rlistings} or a \code{list} object.

the preprocessing function returns a \code{list} of \code{data.frame}.
}
\description{
\code{AEL01_NOLLT} Listing 1 (Default) Glossary of Preferred Terms and Investigator-Specified Terms.
}
\details{
\itemize{
\item Removes duplicate rows.
\item By default, uses dataset \code{adae}, sorting by key columns \code{AEBODSYS} and \code{AEDECOD}.
\item If using with a dataset other than \code{adae}, be sure to specify the desired labels for variables in
\code{key_cols} and \code{disp_cols}, and pre-process missing data.
}
}
\section{Functions}{
\itemize{
\item \code{ael01_nollt_main()}: Main TLG function

\item \code{ael01_nollt_pre()}: Preprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain the \code{dataset} table with columns specified by \code{key_cols} and \code{disp_cols}.
}
}
\examples{
run(ael01_nollt, syn_data)
}
\keyword{datasets}
